/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class ExpressionFunctionTest
extends ContextTestSupport {
    @Test
    public void testTransform() throws Exception {
        MockEndpoint functionMock = this.getMockEndpoint("mock:function");
        functionMock.expectedMessageCount(1);
        functionMock.expectedBodyReceived().constant((Object)"function");
        MockEndpoint inFunctionMock = this.getMockEndpoint("mock:inFunction");
        inFunctionMock.expectedMessageCount(1);
        inFunctionMock.expectedBodyReceived().constant((Object)"inFunction");
        MockEndpoint inFunction2Mock = this.getMockEndpoint("mock:inFunction2");
        inFunction2Mock.expectedMessageCount(1);
        inFunction2Mock.expectedBodyReceived().constant((Object)"inFunction2");
        this.template.sendBodyAndHeader("direct:function", (Object)"Hello World", "type", (Object)"function");
        this.template.sendBodyAndHeader("direct:inFunction", (Object)"Hello World", "type", (Object)"inFunction");
        this.template.sendBodyAndHeader("direct:inFunction2", (Object)"Hello World", "type", (Object)"inFunction2");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:function").transform().message(m -> m.getExchange().getIn().getHeader("type"))).to("mock:function");
                ((ProcessorDefinition)this.from("direct:inFunction").transform().message(m -> m.getHeader("type"))).to("mock:inFunction");
                ((RouteDefinition)this.from("direct:inFunction2").transform(ExpressionBuilder.messageExpression(m -> m.getHeader("type")))).to("mock:inFunction2");
            }
        };
    }
}

