/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExpressionBuilderTest
extends TestSupport {
    protected final CamelContext camelContext = new DefaultCamelContext();
    protected final Exchange exchange = new DefaultExchange(this.camelContext);

    @Test
    public void testRegexTokenize() {
        Expression expression = ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)",");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Islington", "London", "UK"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
        Predicate predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"London"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, true);
        predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"Manchester"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, false);
    }

    @Test
    public void testRegexReplaceAll() {
        Expression expression = ExpressionBuilder.regexReplaceAll((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)"London", (String)"Westminster");
        ExpressionBuilderTest.assertExpression(expression, this.exchange, "Islington,Westminster,UK");
        expression = ExpressionBuilder.regexReplaceAll((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)"London", (Expression)ExpressionBuilder.headerExpression((String)"name"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, "Islington,James,UK");
    }

    @Test
    public void testTokenize() {
        Expression expression = ExpressionBuilder.tokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)",");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Islington", "London", "UK"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
        Predicate predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.tokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"London"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, true);
        predicate = PredicateBuilder.contains((Expression)ExpressionBuilder.tokenizeExpression((Expression)ExpressionBuilder.headerExpression((String)"location"), (String)","), (Expression)ExpressionBuilder.constantExpression((Object)"Manchester"));
        ExpressionBuilderTest.assertPredicate(predicate, this.exchange, false);
    }

    @Test
    public void testTokenizeLines() {
        Expression expression = ExpressionBuilder.regexTokenizeExpression((Expression)ExpressionBuilder.bodyExpression(), (String)"[\r|\n]");
        this.exchange.getIn().setBody((Object)"Hello World\nBye World\rSee you again");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Hello World", "Bye World", "See you again"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
    }

    @Test
    public void testSortLines() {
        Expression expression = ExpressionBuilder.sortExpression((Expression)ExpressionBuilderTest.body().tokenize(",").getExpression(), (Comparator)new SortByName());
        this.exchange.getIn().setBody((Object)"Jonathan,Claus,James,Hadrian");
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("Claus", "Hadrian", "James", "Jonathan"));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, expected);
    }

    @Test
    public void testCamelContextPropertiesExpression() {
        this.camelContext.getGlobalOptions().put("CamelTestKey", "CamelTestValue");
        Expression expression = ExpressionBuilder.camelContextPropertyExpression((String)"CamelTestKey");
        expression.init(this.camelContext);
        ExpressionBuilderTest.assertExpression(expression, this.exchange, "CamelTestValue");
        expression = ExpressionBuilder.camelContextPropertiesExpression();
        expression.init(this.camelContext);
        Map properties = (Map)expression.evaluate(this.exchange, Map.class);
        Assertions.assertEquals((int)1, (int)properties.size(), (String)"Get a wrong properties size");
    }

    @Test
    public void testParseSimpleOrFallbackToConstantExpression() {
        Expression exp = ExpressionBuilder.simpleExpression((String)"world");
        exp.init(this.camelContext);
        Assertions.assertEquals((Object)"world", (Object)exp.evaluate(this.exchange, String.class));
        exp = ExpressionBuilder.simpleExpression((String)"${body}");
        exp.init(this.camelContext);
        Assertions.assertEquals((Object)"Hello there!", (Object)exp.evaluate(this.exchange, String.class));
        exp = ExpressionBuilder.simpleExpression((String)"$simple{body}");
        exp.init(this.camelContext);
        Assertions.assertEquals((Object)"Hello there!", (Object)exp.evaluate(this.exchange, String.class));
    }

    @Test
    public void testFunction() {
        ExpressionBuilderTest.assertExpression(ExpressionBuilder.messageExpression(m -> m.getExchange().getIn().getHeader("name")), this.exchange, "James");
        ExpressionBuilderTest.assertExpression(ExpressionBuilder.messageExpression(m -> m.getHeader("name")), this.exchange, "James");
    }

    @Test
    public void testHeaderExpression() {
        ExpressionBuilderTest.assertExpression(ExpressionBuilder.headerExpression((String)"name", String.class), this.exchange, "James");
    }

    @Test
    public void testConstantsOnly() {
        Expression expression = ExpressionBuilder.concatExpression(List.of(ExpressionBuilder.constantExpression((Object)"Hello"), ExpressionBuilder.constantExpression((Object)" big "), ExpressionBuilder.constantExpression((Object)"World")));
        ExpressionBuilderTest.assertExpression(expression, this.exchange, "Hello big World");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Message in = this.exchange.getIn();
        in.setBody((Object)"Hello there!");
        in.setHeader("name", (Object)"James");
        in.setHeader("location", (Object)"Islington,London,UK");
    }

    private static class SortByName
    implements Comparator<String> {
        private SortByName() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

