/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.SimpleExpression;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionBuilderConcurrencyTest
extends ContextTestSupport {
    @Test
    public void testConcatExpressionConcurrency() throws Exception {
        MockEndpoint mockWithFailure = this.getMockEndpoint("mock:result");
        mockWithFailure.expectedMinimumMessageCount(100);
        mockWithFailure.assertIsSatisfied();
        List exchanges = mockWithFailure.getExchanges();
        exchanges.stream().forEach(exchange -> Assertions.assertEquals((Object)"This is a test a with startLabel: `Document` endLabel: `Document` and label: `ALabel`", (Object)exchange.getMessage().getHeader("#CustomHeader", String.class)));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){
            final Map<String, String> body = Map.of("label", "ALabel", "startLabel", "Document", "endLabel", "Document");
            final String simpleTemplate = "This is a test a with startLabel: `${body.get('startLabel')}` endLabel: `${body.get('endLabel')}` and label: `${body.get('label')}`";

            public void configure() {
                ((RouteDefinition)this.from("timer://test-timer3?fixedRate=true&period=10&delay=1").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody(body);
                        exchange.getMessage().setHeader("#CustomHeader", (Object)ExpressionBuilderConcurrencyTest.this.resolveTemplate("This is a test a with startLabel: `${body.get('startLabel')}` endLabel: `${body.get('endLabel')}` and label: `${body.get('label')}`", exchange));
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("timer://test-timer4?fixedRate=true&period=10&delay=1").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody(body);
                        exchange.getMessage().setHeader("#CustomHeader", (Object)ExpressionBuilderConcurrencyTest.this.resolveTemplate("This is a test a with startLabel: `${body.get('startLabel')}` endLabel: `${body.get('endLabel')}` and label: `${body.get('label')}`", exchange));
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("timer://test-timer5?fixedRate=true&period=10&delay=1").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody(body);
                        exchange.getMessage().setHeader("#CustomHeader", (Object)ExpressionBuilderConcurrencyTest.this.resolveTemplate("This is a test a with startLabel: `${body.get('startLabel')}` endLabel: `${body.get('endLabel')}` and label: `${body.get('label')}`", exchange));
                    }
                })).to("mock:result");
            }
        };
    }

    public String resolveTemplate(String template, Exchange exchange) {
        SimpleExpression simpleExpression = new SimpleExpression();
        simpleExpression.setExpression(template);
        return (String)simpleExpression.evaluate(exchange, String.class);
    }
}

