/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ExchangeBuilderTest {
    private static CamelContext context;
    private static final String BODY = "Message Body";
    private static final String KEY = "Header key";
    private static final String VALUE = "Header value";
    private static final String PROPERTY_KEY = "Property key";
    private static final String PROPERTY_VALUE = "Property value";

    @BeforeAll
    public static void init() {
        context = new DefaultCamelContext();
    }

    @AfterAll
    public static void destroy() {
        context = null;
    }

    @Test
    public void testBuildAnExchangeWithDefaultPattern() {
        DefaultExchange exchange = new DefaultExchange(context);
        Exchange builtExchange = ExchangeBuilder.anExchange((CamelContext)context).build();
        Assertions.assertEquals((Object)exchange.getPattern(), (Object)builtExchange.getPattern());
    }

    @Test
    public void testBuildAnExchangeWithBodyHeaderAndPatternInOnly() {
        Exchange exchange = ExchangeBuilder.anExchange((CamelContext)context).withBody((Object)BODY).withHeader(KEY, (Object)VALUE).withProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE).withPattern(ExchangePattern.InOnly).build();
        Assertions.assertEquals((Object)BODY, (Object)exchange.getMessage().getBody());
        Assertions.assertEquals((Object)VALUE, (Object)exchange.getMessage().getHeader(KEY));
        Assertions.assertEquals((Object)ExchangePattern.InOnly, (Object)exchange.getPattern());
        Assertions.assertEquals((Object)PROPERTY_VALUE, (Object)exchange.getProperty(PROPERTY_KEY));
    }

    @Test
    public void testBuildAnExchangeWithBodyHeaderAndPatternInOut() {
        Exchange exchange = ExchangeBuilder.anExchange((CamelContext)context).withBody((Object)BODY).withHeader(KEY, (Object)VALUE).withProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE).withPattern(ExchangePattern.InOut).build();
        Assertions.assertEquals((Object)BODY, (Object)exchange.getIn().getBody());
        Assertions.assertEquals((Object)VALUE, (Object)exchange.getIn().getHeader(KEY));
        Assertions.assertEquals((Object)ExchangePattern.InOut, (Object)exchange.getPattern());
        Assertions.assertEquals((Object)PROPERTY_VALUE, (Object)exchange.getProperty(PROPERTY_KEY));
    }
}

