/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExceptionBuilderWithHandledExceptionTest
extends ContextTestSupport {
    private static final String MESSAGE_INFO = "messageInfo";
    private static final String RESULT_QUEUE = "mock:result";
    private static final String ERROR_QUEUE = "mock:error";

    @Test
    public void testHandledException() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Handled exchange with NullPointerException");
        this.template.sendBody("direct:a", (Object)"Hello NPE");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    @Test
    public void testHandledExceptionWithExpression() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Handled exchange with IOException");
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello IOE", "foo", (Object)"bar");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    @Test
    public void testUnhandledException() throws Exception {
        MockEndpoint result = this.getMockEndpoint(RESULT_QUEUE);
        result.expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Handled exchange with IOException");
        Exception ex = (Exception)Assertions.assertThrows(RuntimeCamelException.class, () -> this.template.sendBodyAndHeader("direct:a", (Object)"Hello IOE", "foo", (Object)"something that does not match"), (String)"Should have thrown a IOException");
        boolean b = ex.getCause() instanceof IOException;
        Assertions.assertTrue((boolean)b);
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{result, mock});
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel(ExceptionBuilderWithHandledExceptionTest.ERROR_QUEUE).redeliveryDelay(0L).maximumRedeliveries(3));
                ((OnExceptionDefinition)this.onException(NullPointerException.class).maximumRedeliveries(0).handled(true).setHeader(ExceptionBuilderWithHandledExceptionTest.MESSAGE_INFO, (Expression)this.constant("Handled exchange with NullPointerException"))).to(ExceptionBuilderWithHandledExceptionTest.ERROR_QUEUE);
                ((OnExceptionDefinition)this.onException(IOException.class).maximumRedeliveries(0).handled(this.header("foo").isEqualTo((Object)"bar")).setHeader(ExceptionBuilderWithHandledExceptionTest.MESSAGE_INFO, (Expression)this.constant("Handled exchange with IOException"))).to(ExceptionBuilderWithHandledExceptionTest.ERROR_QUEUE);
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String s = (String)exchange.getIn().getBody(String.class);
                        if ("Hello NPE".equals(s)) {
                            throw new NullPointerException();
                        }
                        if ("Hello IOE".equals(s)) {
                            throw new ConnectException("Forced for testing - cannot connect to remote server");
                        }
                        exchange.getMessage().setBody((Object)"Hello World");
                    }
                })).to(ExceptionBuilderWithHandledExceptionTest.RESULT_QUEUE);
            }
        };
    }
}

