/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Channel;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorHandlerTest
extends TestSupport {
    @Test
    public void testOverloadingTheDefaultErrorHandler() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("log:com.mycompany.foo"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Number routes created" + String.valueOf(list)));
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            Assertions.assertEquals((Object)"seda://a", (Object)key.getEndpointUri(), (String)"From endpoint");
            DefaultRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(DefaultRoute.class, route);
            Channel channel = ErrorHandlerTest.unwrapChannel(consumerRoute.getProcessor());
            Assertions.assertNotNull((Object)channel, (String)"The channel should not be null");
            ErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, channel.getErrorHandler());
            Processor processor = ErrorHandlerTest.unwrap(channel.getNextProcessor());
            ErrorHandlerTest.assertIsInstanceOf(SendProcessor.class, processor);
        }
    }

    @Test
    public void testOverloadingTheHandlerOnASingleRoute() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("log:com.mycompany.foo")).to("seda:b");
                this.from("seda:b").to("seda:c");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        Assertions.assertEquals((int)2, (int)list.size(), (String)("Number routes created" + String.valueOf(list)));
    }

    @Test
    public void testConfigureDeadLetterChannel() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("seda:errors"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Number routes created" + String.valueOf(list)));
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            Assertions.assertEquals((Object)"seda://a", (Object)key.getEndpointUri(), (String)"From endpoint");
            DefaultRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(DefaultRoute.class, route);
            Channel channel = ErrorHandlerTest.unwrapChannel(consumerRoute.getProcessor());
            Assertions.assertNotNull((Object)channel, (String)"The channel should not be null");
            ErrorHandlerTest.assertIsInstanceOf(SendProcessor.class, channel.getNextProcessor());
        }
    }

    @Test
    public void testConfigureDeadLetterChannelWithCustomRedeliveryPolicy() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("seda:errors").maximumRedeliveries(2).useExponentialBackOff());
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = ErrorHandlerTest.getRouteList(builder);
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Number routes created" + String.valueOf(list)));
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            Assertions.assertEquals((Object)"seda://a", (Object)key.getEndpointUri(), (String)"From endpoint");
            DefaultRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(DefaultRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            Channel channel = ErrorHandlerTest.unwrapChannel(processor);
            Assertions.assertNotNull((Object)channel, (String)"The channel should not be null");
            DeadLetterChannel deadLetterChannel = ErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, channel.getErrorHandler());
            RedeliveryPolicy redeliveryPolicy = deadLetterChannel.getRedeliveryPolicy();
            Assertions.assertEquals((int)2, (int)redeliveryPolicy.getMaximumRedeliveries(), (String)"getMaximumRedeliveries()");
            Assertions.assertTrue((boolean)redeliveryPolicy.isUseExponentialBackOff(), (String)"isUseExponentialBackOff()");
        }
    }

    @Test
    public void testLoggingErrorHandler() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("log:FOO.BAR")).filter(this.body().isInstanceOf(String.class)).to("seda:b");
            }
        };
        List<Route> routes = ErrorHandlerTest.getRouteList(builder);
        Assertions.assertEquals((int)1, (int)routes.size(), (String)"Number routes created");
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            Assertions.assertEquals((Object)"seda://a", (Object)key.getEndpointUri(), (String)"From endpoint");
            DefaultRoute consumerRoute = ErrorHandlerTest.assertIsInstanceOf(DefaultRoute.class, route);
            Channel channel = ErrorHandlerTest.unwrapChannel(consumerRoute.getProcessor());
            Assertions.assertNotNull((Object)channel, (String)"The channel should not be null");
            ErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, channel.getErrorHandler());
            ErrorHandlerTest.assertIsInstanceOf(FilterProcessor.class, channel.getNextProcessor());
        }
    }
}

