/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Properties;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class ErrorHandlerRefPropertyPlaceholderTest
extends ContextTestSupport {
    @Test
    public void testRef() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:dead");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Properties prop = new Properties();
                prop.put("myErrorHandler", "myDead");
                ErrorHandlerRefPropertyPlaceholderTest.this.context.getPropertiesComponent().setOverrideProperties(prop);
                DeadLetterChannelBuilder dlc = new DeadLetterChannelBuilder("mock:dead");
                ErrorHandlerRefPropertyPlaceholderTest.this.context.getRegistry().bind("myDead", (Object)dlc);
                this.errorHandler("{{myErrorHandler}}");
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

