/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Channel;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContextErrorHandlerTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.setUseRouteBuilder(false);
        super.setUp();
        RedeliveryPolicyDefinition redeliveryPolicy = new RedeliveryPolicyDefinition();
        redeliveryPolicy.maximumRedeliveries(1);
        redeliveryPolicy.setUseExponentialBackOff("true");
        DeadLetterChannelBuilder deadLetterChannelBuilder = new DeadLetterChannelBuilder("mock:error");
        deadLetterChannelBuilder.setRedeliveryPolicy(redeliveryPolicy);
        this.context.getCamelContextExtension().setErrorHandlerFactory((ErrorHandlerFactory)deadLetterChannelBuilder);
    }

    @Override
    protected void startCamelContext() {
    }

    @Override
    protected void stopCamelContext() {
    }

    protected List<Route> getRouteListWithCurrentContext(RouteBuilder builder) throws Exception {
        this.context.addRoutes((RoutesBuilder)builder);
        this.context.start();
        List answer = this.context.getRoutes();
        this.context.stop();
        return answer;
    }

    @Test
    public void testOverloadingTheDefaultErrorHandler() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("log:FOO.BAR"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = this.getRouteListWithCurrentContext(builder);
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Number routes created" + String.valueOf(list)));
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            Assertions.assertEquals((Object)"seda://a", (Object)key.getEndpointUri(), (String)"From endpoint");
            DefaultRoute consumerRoute = ContextErrorHandlerTest.assertIsInstanceOf(DefaultRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            Channel channel = ContextErrorHandlerTest.unwrapChannel(processor);
            Assertions.assertNotNull((Object)channel, (String)"The channel should not be null");
            ContextErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, channel.getErrorHandler());
            SendProcessor sendProcessor = ContextErrorHandlerTest.assertIsInstanceOf(SendProcessor.class, channel.getNextProcessor());
            this.log.debug("Found sendProcessor: {}", (Object)sendProcessor);
        }
    }

    @Test
    public void testGetTheDefaultErrorHandlerFromContext() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").to("seda:b");
                this.from("direct:c").to("direct:d");
            }
        };
        List<Route> list = this.getRouteListWithCurrentContext(builder);
        Assertions.assertEquals((int)2, (int)list.size(), (String)("Number routes created" + String.valueOf(list)));
        for (Route route : list) {
            DefaultRoute consumerRoute = ContextErrorHandlerTest.assertIsInstanceOf(DefaultRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            Channel channel = ContextErrorHandlerTest.unwrapChannel(processor);
            Assertions.assertNotNull((Object)channel, (String)"The channel should not be null");
            DeadLetterChannel deadLetterChannel = ContextErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, channel.getErrorHandler());
            RedeliveryPolicy redeliveryPolicy = deadLetterChannel.getRedeliveryPolicy();
            Assertions.assertEquals((int)1, (int)redeliveryPolicy.getMaximumRedeliveries(), (String)"getMaximumRedeliveries()");
            Assertions.assertTrue((boolean)redeliveryPolicy.isUseExponentialBackOff(), (String)"isUseExponentialBackOff()");
        }
    }
}

