/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.support.processor.DelegateProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BuilderWithScopesTest
extends TestSupport {
    final List<String> order = new ArrayList<String>();
    final DelegateProcessor interceptor1 = new DelegateProcessor(){

        public void process(Exchange exchange) throws Exception {
            BuilderWithScopesTest.this.order.add("START:1");
            super.process(exchange);
            BuilderWithScopesTest.this.order.add("END:1");
        }
    };
    final DelegateProcessor interceptor2 = new DelegateProcessor(){

        public void process(Exchange exchange) throws Exception {
            BuilderWithScopesTest.this.order.add("START:2");
            super.process(exchange);
            BuilderWithScopesTest.this.order.add("END:2");
        }
    };
    final Processor orderProcessor = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("INVOKED");
        }
    };
    final Processor orderProcessor2 = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("INVOKED2");
        }
    };
    final Processor orderProcessor3 = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("INVOKED3");
        }
    };
    final Processor toProcessor = new Processor(){

        public void process(Exchange exchange) {
            BuilderWithScopesTest.this.order.add("TO");
        }
    };
    final Processor validator = new Processor(){

        public void process(Exchange exchange) throws Exception {
            BuilderWithScopesTest.this.order.add("VALIDATE");
            Object value = exchange.getIn().getHeader("foo");
            if (value == null) {
                throw new IllegalArgumentException("The foo header is not present.");
            }
            if (!value.equals("bar")) {
                throw new ValidationException(exchange, "The foo header does not equal bar! Was: " + String.valueOf(value));
            }
        }
    };

    protected void runTest(RouteBuilder builder, List<String> expected) throws Exception {
        this.runTest(builder, expected, null);
    }

    protected void runTest(RouteBuilder builder, List<String> expected, String header) throws Exception {
        this.order.clear();
        DefaultCamelContext container = new DefaultCamelContext(false);
        container.disableJMX();
        container.build();
        container.addRoutes((RoutesBuilder)builder);
        container.start();
        Endpoint endpoint = container.getEndpoint("direct:a");
        Exchange exchange = endpoint.createExchange();
        if (header != null) {
            exchange.getIn().setHeader("foo", (Object)header);
        }
        Producer producer = endpoint.createProducer();
        producer.process(exchange);
        this.log.debug("Invocation order: {}", this.order);
        Assertions.assertEquals(expected, this.order);
        container.stop();
    }

    @Test
    public void testRouteWithFilterEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("TO");
        this.runTest(new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                ((ExpressionNode)this.from("direct:a").filter(this.header("foo").isEqualTo((Object)"bar")).process(BuilderWithScopesTest.this.orderProcessor)).end().process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "banana");
    }

    @Test
    public void testRouteWithFilterNoEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        this.runTest(new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                ((ExpressionNode)this.from("direct:a").filter(this.header("foo").isEqualTo((Object)"bar")).process(BuilderWithScopesTest.this.orderProcessor)).process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "banana");
    }

    protected RouteBuilder createChoiceBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when(this.header("foo").isEqualTo((Object)"bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo((Object)"cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).end().process(BuilderWithScopesTest.this.toProcessor);
            }
        };
    }

    @Test
    public void testRouteWithChoice1() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        expected.add("TO");
        this.runTest(this.createChoiceBuilder(), expected, "bar");
    }

    @Test
    public void testRouteWithChoice2() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED2");
        expected.add("TO");
        this.runTest(this.createChoiceBuilder(), expected, "cheese");
    }

    @Test
    public void testRouteWithChoice3() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("TO");
        this.runTest(this.createChoiceBuilder(), expected, "banana");
    }

    @Test
    public void testRouteWithChoiceNoEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        this.runTest(new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when(this.header("foo").isEqualTo((Object)"bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo((Object)"cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "bar");
    }

    protected RouteBuilder createChoiceWithOtherwiseBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when(this.header("foo").isEqualTo((Object)"bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo((Object)"cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).otherwise().process(BuilderWithScopesTest.this.orderProcessor3)).end().process(BuilderWithScopesTest.this.toProcessor);
            }
        };
    }

    @Test
    public void testRouteWithChoiceOtherwise1() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        expected.add("TO");
        this.runTest(this.createChoiceWithOtherwiseBuilder(), expected, "bar");
    }

    @Test
    public void testRouteWithChoiceOtherwise2() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED2");
        expected.add("TO");
        this.runTest(this.createChoiceWithOtherwiseBuilder(), expected, "cheese");
    }

    @Test
    public void testRouteWithChoiceOtherwise3() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED3");
        expected.add("TO");
        this.runTest(this.createChoiceWithOtherwiseBuilder(), expected, "banana");
    }

    @Test
    public void testRouteWithChoiceOtherwiseNoEnd() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("INVOKED");
        this.runTest(new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when(this.header("foo").isEqualTo((Object)"bar")).process(BuilderWithScopesTest.this.orderProcessor)).when(this.header("foo").isEqualTo((Object)"cheese")).process(BuilderWithScopesTest.this.orderProcessor2)).otherwise().process(BuilderWithScopesTest.this.orderProcessor3)).process(BuilderWithScopesTest.this.toProcessor);
            }
        }, expected, "bar");
    }

    protected RouteBuilder createTryCatchNoEnd() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:a").doTry().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).doCatch(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).process(BuilderWithScopesTest.this.orderProcessor3)).end();
            }
        };
    }

    @Test
    public void testRouteWithTryCatchNoEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        this.runTest(this.createTryCatchNoEnd(), expected, "bar");
    }

    @Test
    public void testRouteWithTryCatchNoEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchNoEnd(), expected, "banana");
    }

    @Test
    public void testRouteWithTryCatchNoEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        this.runTest(this.createTryCatchNoEnd(), expected);
    }

    protected RouteBuilder createTryCatchEnd() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:a").doTry().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).doCatch(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).end().process(BuilderWithScopesTest.this.orderProcessor3);
            }
        };
    }

    @Test
    public void testRouteWithTryCatchEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchEnd(), expected, "bar");
    }

    @Test
    public void testRouteWithTryCatchEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchEnd(), expected, "banana");
    }

    @Test
    public void testRouteWithTryCatchEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        this.runTest(this.createTryCatchEnd(), expected);
    }

    protected RouteBuilder createTryCatchFinallyNoEnd() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:a").doTry().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).doCatch(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).doFinally().process(BuilderWithScopesTest.this.orderProcessor2)).process(BuilderWithScopesTest.this.orderProcessor3);
            }
        };
    }

    @Test
    public void testRouteWithTryCatchFinallyNoEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyNoEnd(), expected, "bar");
    }

    @Test
    public void testRouteWithTryCatchFinallyNoEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyNoEnd(), expected, "banana");
    }

    @Test
    public void testRouteWithTryCatchFinallyNoEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyNoEnd(), expected);
    }

    protected RouteBuilder createTryCatchFinallyEnd() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:a").doTry().process(BuilderWithScopesTest.this.validator)).process(BuilderWithScopesTest.this.toProcessor)).doCatch(ValidationException.class).process(BuilderWithScopesTest.this.orderProcessor)).doFinally().process(BuilderWithScopesTest.this.orderProcessor2)).end().process(BuilderWithScopesTest.this.orderProcessor3);
            }
        };
    }

    @Test
    public void testRouteWithTryCatchFinallyEndNoException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("TO");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyEnd(), expected, "bar");
    }

    @Test
    public void testRouteWithTryCatchFinallyEndWithCaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED");
        expected.add("INVOKED2");
        expected.add("INVOKED3");
        this.runTest(this.createTryCatchFinallyEnd(), expected, "banana");
    }

    @Test
    public void testRouteWithTryCatchFinallyEndWithUncaughtException() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("VALIDATE");
        expected.add("INVOKED2");
        this.runTest(this.createTryCatchFinallyEnd(), expected);
    }
}

