/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AddRoutesAtRuntimeTest
extends ContextTestSupport {
    @Test
    public void testAddRoutesAtRuntime() throws Exception {
        this.getMockEndpoint("mock:start").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new MyDynamcRouteBuilder((CamelContext)this.context, "direct:foo", "mock:foo"));
        this.template.sendBody("direct:foo", (Object)"Bye Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Method m = AbstractCamelContext.class.getDeclaredMethod("getBootstraps", new Class[0]);
        m.setAccessible(true);
        Assertions.assertEquals((int)0, (int)((List)m.invoke((Object)this.context, new Object[0])).size());
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.context.addRoutes((RoutesBuilder)new MyDynamcRouteBuilder((CamelContext)this.context, "direct:bar", "mock:bar"));
        this.template.sendBody("direct:bar", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)0, (int)((List)m.invoke((Object)this.context, new Object[0])).size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:start");
            }
        };
    }

    private static final class MyDynamcRouteBuilder
    extends RouteBuilder {
        private final String from;
        private final String to;

        private MyDynamcRouteBuilder(CamelContext context, String from, String to) {
            super(context);
            this.from = from;
            this.to = to;
        }

        public void configure() {
            this.from(this.from).to(this.to);
        }
    }
}

