/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestSupportJmxCleanup {
    public static final String DEFAULT_DOMAIN = "org.apache.camel";
    private static final Logger LOG = LoggerFactory.getLogger(TestSupportJmxCleanup.class);

    private TestSupportJmxCleanup() {
    }

    public static void removeMBeans(String domain) throws Exception {
        MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> s = mbsc.queryNames(new ObjectName(TestSupportJmxCleanup.getDomainName(domain) + ":*"), null);
        for (ObjectName on : s) {
            mbsc.unregisterMBean(on);
        }
    }

    public static void traceMBeans(String domain) throws Exception {
        String d;
        MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> s = mbsc.queryNames(new ObjectName((d = TestSupportJmxCleanup.getDomainName(domain)) + ":*"), null);
        if (!s.isEmpty()) {
            LOG.warn(" + {} ObjectNames registered in domain \"{}\"", (Object)s.size(), (Object)d);
            for (ObjectName on : s) {
                LOG.warn(" |  {}", (Object)on);
            }
        }
    }

    private static String getDomainName(String domain) {
        return domain == null ? DEFAULT_DOMAIN : domain;
    }
}

