/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Channel;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupportJmxCleanup;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.PredicateAssertHelper;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
public abstract class TestSupport {
    protected static final String LS = System.lineSeparator();
    private static final Logger LOG = LoggerFactory.getLogger(TestSupport.class);
    protected TestInfo info;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @TempDir
    private Path tempDirectory;

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.info.getTestMethod().map(Method::getName).orElse("");
    }

    @BeforeEach
    public void setTestInfo(TestInfo info) {
        this.info = info;
    }

    @BeforeEach
    public void setUp() throws Exception {
        Assumptions.assumeTrue((boolean)this.canRunOnThisPlatform());
    }

    @Deprecated(since="4.3.0")
    public void deleteTestDirectory() {
    }

    @AfterEach
    public void tearDown() throws Exception {
        TestSupportJmxCleanup.removeMBeans(null);
    }

    public Path testDirectory() {
        return this.tempDirectory;
    }

    protected Path testFile(String file) {
        return TestSupport.testFile(this.testDirectory(), file);
    }

    protected static Path testFile(Path testDirectory, String file) {
        return testDirectory.resolve(file);
    }

    protected Path testDirectory(String path) {
        return this.testDirectory(path, false);
    }

    @Deprecated(since="4.3.0")
    protected Path testDirectory(boolean create) {
        return this.testDirectory();
    }

    @Deprecated(since="4.3.0")
    public static Path testDirectory(Class<?> testClass, boolean create) {
        Path dir = Paths.get("target", "data", testClass.getSimpleName());
        if (create) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create test directory: " + String.valueOf(dir), e);
            }
        }
        return dir;
    }

    protected Path testDirectory(String path, boolean create) {
        Path resolvedPath = this.testDirectory().resolve(path);
        if (create) {
            try {
                Files.createDirectories(resolvedPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create test directory: " + String.valueOf(resolvedPath), e);
            }
        }
        return resolvedPath;
    }

    public static boolean isCamelDebugPresent() {
        return Thread.currentThread().getContextClassLoader().getResource(String.format("%s%s", "META-INF/services/org/apache/camel/", "debugger-factory")) != null;
    }

    protected String fileUri() {
        return "file:" + String.valueOf(this.tempDirectory);
    }

    protected String fileUri(String query) {
        return this.fileUri(this.tempDirectory, query);
    }

    protected String fileUri(Path directory, String query) {
        return "file:" + String.valueOf(directory) + (query.startsWith("?") ? "" : "/") + query;
    }

    protected boolean canRunOnThisPlatform() {
        return true;
    }

    public static ValueBuilder header(String name) {
        return Builder.header((String)name);
    }

    public static ValueBuilder exchangeProperty(String name) {
        return Builder.exchangeProperty((String)name);
    }

    public static ValueBuilder body() {
        return TestSupport.init(Builder.body());
    }

    public static <T> ValueBuilder bodyAs(Class<T> type) {
        return Builder.bodyAs(type);
    }

    public static ValueBuilder systemProperty(String name) {
        return Builder.systemProperty((String)name);
    }

    public static ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty((String)name, (String)defaultValue);
    }

    public static <T> T assertIsInstanceOf(Class<T> expectedType, Object value) {
        Assertions.assertNotNull((Object)value, (String)("Expected an instance of type: " + expectedType.getName() + " but was null"));
        Assertions.assertTrue((boolean)expectedType.isInstance(value), (String)("object should be a " + expectedType.getName() + " but was: " + String.valueOf(value) + " with type: " + value.getClass().getName()));
        return expectedType.cast(value);
    }

    public static void assertEndpointUri(Endpoint endpoint, String uri) {
        Assertions.assertNotNull((Object)endpoint, (String)("Endpoint is null when expecting endpoint for: " + uri));
        Assertions.assertEquals((Object)uri, (Object)endpoint.getEndpointUri(), (String)("Endoint uri for: " + String.valueOf(endpoint)));
    }

    public static Object assertInMessageHeader(Exchange exchange, String name, Object expected) {
        return TestSupport.assertMessageHeader(exchange.getIn(), name, expected);
    }

    public static void assertInMessageBodyEquals(Exchange exchange, Object expected) throws InvalidPayloadException {
        Object actual;
        Assertions.assertNotNull((Object)exchange, (String)"Should have a response exchange!");
        if (expected == null) {
            actual = exchange.getIn().getMandatoryBody();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)("in body of: " + String.valueOf(exchange)));
        } else {
            actual = exchange.getIn().getMandatoryBody(expected.getClass());
        }
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("in body of: " + String.valueOf(exchange)));
        LOG.debug("Received response: {} with in: {}", (Object)exchange, (Object)exchange.getIn());
    }

    public static Object assertMessageHeader(Message message, String name, Object expected) {
        Object value = message.getHeader(name);
        Assertions.assertEquals((Object)expected, (Object)value, (String)("Header: " + name + " on Message: " + String.valueOf(message)));
        return value;
    }

    public static Object assertProperty(Exchange exchange, String name, Object expected) {
        Object value = exchange.getProperty(name);
        Assertions.assertEquals((Object)expected, (Object)value, (String)("Property: " + name + " on Exchange: " + String.valueOf(exchange)));
        return value;
    }

    public static Object assertExpression(Expression expression, Exchange exchange, Object expected) {
        expression.init(exchange.getContext());
        Object value = expected != null ? expression.evaluate(exchange, expected.getClass()) : expression.evaluate(exchange, Object.class);
        LOG.debug("Evaluated expression: {} on exchange: {} result: {}", new Object[]{expression, exchange, value});
        Assertions.assertEquals((Object)expected, (Object)value, (String)("Expression: " + String.valueOf(expression) + " on Exchange: " + String.valueOf(exchange)));
        return value;
    }

    public static void assertPredicateMatches(Predicate predicate, Exchange exchange) {
        TestSupport.assertPredicate(predicate, exchange, true);
    }

    public static void assertPredicateDoesNotMatch(Predicate predicate, Exchange exchange) {
        predicate.init(exchange.getContext());
        try {
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)"Predicate should match: ", (Exchange)exchange);
        }
        catch (AssertionError e) {
            LOG.debug("Caught expected assertion error: {}", (Object)((Throwable)((Object)e)).getMessage(), (Object)e);
        }
        TestSupport.assertPredicate(predicate, exchange, false);
    }

    public static boolean assertPredicate(Predicate predicate, Exchange exchange, boolean expected) {
        predicate.init(exchange.getContext());
        if (expected) {
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)"Predicate failed: ", (Exchange)exchange);
        }
        boolean value = predicate.matches(exchange);
        LOG.debug("Evaluated predicate: {} on exchange: {} result: {}", new Object[]{predicate, exchange, value});
        Assertions.assertEquals((Object)expected, (Object)value, (String)("Predicate: " + String.valueOf(predicate) + " on Exchange: " + String.valueOf(exchange)));
        return value;
    }

    public static Endpoint resolveMandatoryEndpoint(CamelContext context, String uri) {
        Endpoint endpoint = context.getEndpoint(uri);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for URI: " + uri));
        return endpoint;
    }

    public static <T extends Endpoint> T resolveMandatoryEndpoint(CamelContext context, String uri, Class<T> endpointType) {
        Endpoint endpoint = context.getEndpoint(uri, endpointType);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for URI: " + uri));
        return (T)endpoint;
    }

    protected Exchange createExchangeWithBody(CamelContext camelContext, Object body) {
        DefaultExchange exchange = new DefaultExchange(camelContext);
        Message message = exchange.getIn();
        message.setHeader("testName", (Object)this.getName());
        message.setHeader("testClass", (Object)this.getClass().getName());
        message.setBody(body);
        return exchange;
    }

    public static <T> T assertOneElement(List<T> list) {
        Assertions.assertEquals((int)1, (int)list.size(), (String)("Size of list should be 1: " + String.valueOf(list)));
        return list.get(0);
    }

    public static <T> List<T> assertListSize(List<T> list, int size) {
        return TestSupport.assertListSize("List", list, size);
    }

    public static <T> List<T> assertListSize(String message, List<T> list, int size) {
        Assertions.assertEquals((int)size, (int)list.size(), (String)(message + " should be of size: " + size + " but is: " + String.valueOf(list)));
        return list;
    }

    public static <T> Collection<T> assertCollectionSize(Collection<T> list, int size) {
        return TestSupport.assertCollectionSize("List", list, size);
    }

    public static <T> Collection<T> assertCollectionSize(String message, Collection<T> list, int size) {
        Assertions.assertEquals((int)size, (int)list.size(), (String)(message + " should be of size: " + size + " but is: " + String.valueOf(list)));
        return list;
    }

    public static List<Route> getRouteList(RouteBuilder builder) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        ((SedaComponent)context.getComponent("seda", SedaComponent.class)).setDefaultPollTimeout(10);
        context.addRoutes((RoutesBuilder)builder);
        context.start();
        List answer = context.getRoutes();
        context.stop();
        return answer;
    }

    public static void assertStringContains(String text, String containedText) {
        Assertions.assertNotNull((Object)text, (String)"Text should not be null!");
        Assertions.assertTrue((boolean)text.contains(containedText), (String)("Text: " + text + " does not contain: " + containedText));
    }

    public static Processor unwrap(Processor processor) {
        while (processor instanceof DelegateProcessor) {
            DelegateProcessor delegateProcessor = (DelegateProcessor)processor;
            processor = delegateProcessor.getProcessor();
        }
        return processor;
    }

    public static Channel unwrapChannel(Processor processor) {
        while (true) {
            if (processor instanceof Pipeline) {
                Pipeline pipeline = (Pipeline)processor;
                processor = (Processor)pipeline.next().get(0);
            }
            if (processor instanceof Channel) {
                Channel channel = (Channel)processor;
                return channel;
            }
            if (processor instanceof DelegateProcessor) {
                DelegateProcessor delegateProcessor = (DelegateProcessor)processor;
                processor = delegateProcessor.getProcessor();
                continue;
            }
            if (!(processor instanceof ErrorHandlerSupport)) break;
            ErrorHandlerSupport errorHandlerSupport = (ErrorHandlerSupport)processor;
            processor = errorHandlerSupport.getOutput();
        }
        return null;
    }

    @Deprecated(since="4.3.0")
    public static void deleteDirectory(String file) {
        TestSupport.deleteDirectory(new File(file));
    }

    @Deprecated(since="4.3.0")
    public static void deleteDirectory(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                TestSupport.deleteDirectory(child);
            }
        }
        file.delete();
    }

    public static void assertDirectoryEquals(String expected, String actual) {
        TestSupport.assertDirectoryEquals(null, expected, actual);
    }

    public static void assertDirectoryEquals(String message, String expected, String actual) {
        String expectedPath = expected.replace('\\', '/');
        String actualPath = actual.replace('\\', '/');
        if (message != null) {
            Assertions.assertEquals((Object)expectedPath, (Object)actualPath, (String)message);
        } else {
            Assertions.assertEquals((Object)expectedPath, (Object)actualPath);
        }
    }

    public static void assertDirectoryExists(Path file) {
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)("Directory " + String.valueOf(file) + " should exist"));
        Assertions.assertTrue((boolean)Files.isDirectory(file, new LinkOption[0]), (String)("Directory " + String.valueOf(file) + " should be a directory"));
    }

    public static void assertDirectoryExists(String filename) {
        File file = new File(filename);
        Assertions.assertTrue((boolean)file.exists(), (String)("Directory " + filename + " should exist"));
        Assertions.assertTrue((boolean)file.isDirectory(), (String)("Directory " + filename + " should be a directory"));
    }

    public static void assertFileExists(Path file) {
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)("File " + String.valueOf(file) + " should exist"));
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)("File " + String.valueOf(file) + " should be a file"));
    }

    public static void assertFileExists(Path file, String content) throws IOException {
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)("File " + String.valueOf(file) + " should exist"));
        Assertions.assertTrue((boolean)Files.isRegularFile(file, new LinkOption[0]), (String)("File " + String.valueOf(file) + " should be a file"));
        Assertions.assertEquals((Object)content, (Object)new String(Files.readAllBytes(file)), (String)("File " + String.valueOf(file) + " has unexpected content"));
    }

    public static void assertFileExists(String filename) {
        File file = new File(filename);
        Assertions.assertTrue((boolean)file.exists(), (String)("File " + filename + " should exist"));
        Assertions.assertTrue((boolean)file.isFile(), (String)("File " + filename + " should be a file"));
    }

    public static void assertFileNotExists(Path file) {
        Assertions.assertFalse((boolean)Files.exists(file, new LinkOption[0]), (String)("File " + String.valueOf(file) + " should not exist"));
    }

    public static void assertFileNotExists(String filename) {
        File file = new File(filename);
        Assertions.assertFalse((boolean)file.exists(), (String)("File " + filename + " should not exist"));
    }

    public static boolean isPlatform(String platform) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return osName.contains(platform.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isJavaVendor(String vendor) {
        String javaVendor = System.getProperty("java.vendor").toLowerCase(Locale.ENGLISH);
        return javaVendor.contains(vendor.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isJavaVersion(String version) {
        return Integer.parseInt(version) == TestSupport.getJavaMajorVersion();
    }

    public static int getJavaMajorVersion() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        return Integer.parseInt(javaSpecVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSystemProperty(String sysPropertyName, String sysPropertyValue, String separator) {
        Properties properties = System.getProperties();
        synchronized (properties) {
            if (System.getProperties().contains(sysPropertyName)) {
                String current = System.getProperty(sysPropertyName);
                if (!current.contains(sysPropertyValue)) {
                    System.setProperty(sysPropertyName, current + separator + sysPropertyValue);
                }
            } else {
                System.setProperty(sysPropertyName, sysPropertyValue);
            }
        }
    }

    private static ValueBuilder init(ValueBuilder builder) {
        Expression exp = builder.getExpression();
        if (exp != null) {
            exp.init((CamelContext)new DefaultCamelContext());
        }
        return builder;
    }

    public static <T> void assumeThat(String s, T t, Matcher<T> m) {
        Assumptions.assumeTrue((boolean)m.matches(t), (String)s);
    }
}

