/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.spi.Language;
import org.junit.jupiter.api.Assertions;

public abstract class LanguageTestSupport
extends ExchangeTestSupport {
    protected abstract String getLanguageName();

    protected void assertPredicate(String expression) {
        this.assertPredicate(this.exchange, expression, true);
    }

    protected void assertPredicateFails(String expression) {
        this.assertPredicate(this.exchange, expression, false);
    }

    protected void assertPredicate(String expression, boolean expected) {
        this.assertPredicate(this.exchange, expression, expected);
    }

    protected void assertPredicate(Exchange exchange, String expression, boolean expected) {
        this.assertPredicate(this.getLanguageName(), expression, exchange, expected);
    }

    protected void assertExpression(Exchange exchange, String expressionText, Object expectedValue) {
        this.assertExpression(exchange, this.getLanguageName(), expressionText, expectedValue);
    }

    protected void assertExpression(String expressionText, Object expectedValue) {
        this.assertExpression(this.exchange, expressionText, expectedValue);
    }

    protected void assertExpression(String expressionText, String expectedValue, String orThisExpectedValue) {
        Object value = this.evaluateExpression(expressionText, expectedValue.getClass());
        Assertions.assertTrue((expectedValue.equals(value) || orThisExpectedValue.equals(value) ? 1 : 0) != 0, (String)("Expression: " + expressionText + " on Exchange: " + String.valueOf(this.exchange)));
    }

    protected Object evaluateExpression(String expressionText, Class<?> expectedType) {
        Language language = this.assertResolveLanguage(this.getLanguageName());
        Expression expression = language.createExpression(expressionText);
        Assertions.assertNotNull((Object)expression, (String)("No Expression could be created for text: " + expressionText + " language: " + String.valueOf(language)));
        Object value = expectedType != null ? expression.evaluate(this.exchange, expectedType) : expression.evaluate(this.exchange, Object.class);
        this.log.debug("Evaluated expression: {} on exchange: {} result: {}", new Object[]{expression, this.exchange, value});
        return value;
    }
}

