/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Message;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.LanguageBuilderFactory;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.InterceptSendToMockEndpointStrategy;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.BreakpointSupport;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.jndi.JndiTest;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class ContextTestSupport
extends TestSupport
implements BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final ThreadLocal<ModelCamelContext> THREAD_CAMEL_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<ProducerTemplate> THREAD_TEMPLATE = new ThreadLocal();
    private static final ThreadLocal<FluentProducerTemplate> THREAD_FLUENT_TEMPLATE = new ThreadLocal();
    private static final ThreadLocal<ConsumerTemplate> THREAD_CONSUMER = new ThreadLocal();
    private static final ThreadLocal<Service> THREAD_SERVICE = new ThreadLocal();
    public static final String SEPARATOR = "********************************************************************************";
    protected Properties extra;
    protected volatile ModelCamelContext context;
    protected volatile ProducerTemplate template;
    protected volatile FluentProducerTemplate fluentTemplate;
    protected volatile ConsumerTemplate consumer;
    protected volatile Service camelContextService;
    protected volatile NotifyBuilder oneExchangeDone;
    private boolean applyCamelPostProcessor = false;
    private boolean useRouteBuilder = true;
    private final DebugBreakpoint breakpoint = new DebugBreakpoint();
    private final Map<String, String> fromEndpoints = new HashMap<String, String>();
    private final StopWatch watch = new StopWatch();
    private String currentTestName;
    private ExtensionContext.Store contextStore;
    @RegisterExtension
    protected ContextTestSupport contextTestSupportExtension = this;

    public void beforeTestExecution(ExtensionContext context) {
        this.watch.restart();
    }

    public void afterTestExecution(ExtensionContext context) {
        this.watch.taken();
    }

    public long timeTaken() {
        return this.watch.taken();
    }

    public void beforeEach(ExtensionContext context) {
        this.currentTestName = context.getDisplayName();
        this.contextStore = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
    }

    public void afterEach(ExtensionContext context) {
        DefaultCamelContext.clearOptions();
    }

    public boolean isApplyCamelPostProcessor() {
        return this.applyCamelPostProcessor;
    }

    public void setApplyCamelPostProcessor(boolean applyCamelPostProcessor) {
        this.applyCamelPostProcessor = applyCamelPostProcessor;
    }

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public boolean isUseAdviceWith() {
        return false;
    }

    public String isMockEndpoints() {
        return null;
    }

    public String isMockEndpointsAndSkip() {
        return null;
    }

    protected void setAssertPeriod(long period) {
        MockEndpoint.setAssertPeriod((CamelContext)this.context, (long)period);
    }

    public void replaceRouteFromWith(String routeId, String fromEndpoint) {
        this.fromEndpoints.put(routeId, fromEndpoint);
    }

    public String getRouteFilterIncludePattern() {
        return null;
    }

    public String getRouteFilterExcludePattern() {
        return null;
    }

    protected List<Processor> getProcessors(String pattern) {
        return this.context.getRoutes().stream().flatMap(r -> r.filter(pattern).stream()).collect(Collectors.toList());
    }

    public final String getCurrentTestName() {
        return this.currentTestName;
    }

    public final ExtensionContext.Store getContextStore() {
        return this.contextStore;
    }

    public boolean isUseDebugger() {
        return false;
    }

    public Service getCamelContextService() {
        return this.camelContextService;
    }

    public Service camelContextService() {
        return this.camelContextService;
    }

    public CamelContext context() {
        return this.context;
    }

    public ProducerTemplate template() {
        return this.template;
    }

    public FluentProducerTemplate fluentTemplate() {
        return this.fluentTemplate;
    }

    public ConsumerTemplate consumer() {
        return this.consumer;
    }

    public LanguageBuilderFactory expression() {
        return new LanguageBuilderFactory();
    }

    public void setCamelContextService(Service service) {
        this.camelContextService = service;
        THREAD_SERVICE.set(this.camelContextService);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.log.info(SEPARATOR);
        this.log.info("Testing: {} ({})", (Object)this.getCurrentTestName(), (Object)this.getClass().getName());
        this.log.info(SEPARATOR);
        this.doSpringBootCheck();
        this.doQuarkusCheck();
        this.setupResources();
        this.doPreSetup();
        this.doSetUp();
        this.doPostSetup();
        this.oneExchangeDone = this.event().whenDone(1).create();
        this.watch.restart();
    }

    protected void doPreSetup() {
    }

    protected void doPostSetup() {
    }

    protected void doSpringBootCheck() {
        boolean springBoot = this.hasClassAnnotation("org.springframework.boot.test.context.SpringBootTest");
        if (springBoot) {
            throw new RuntimeException("Spring Boot detected: The ContextTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Spring Boot.");
        }
    }

    protected void doQuarkusCheck() {
        boolean quarkus;
        boolean bl = quarkus = this.hasClassAnnotation("io.quarkus.test.junit.QuarkusTest") || this.hasClassAnnotation("org.apache.camel.quarkus.test.CamelQuarkusTest");
        if (quarkus) {
            throw new RuntimeException("Quarkus detected: The ContextTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Quarkus.");
        }
    }

    protected void doSetUp() throws Exception {
        this.log.debug("setUp test");
        if (this.useJmx() || ContextTestSupport.isCamelDebugPresent()) {
            this.enableJMX();
        } else {
            this.disableJMX();
        }
        this.context = (ModelCamelContext)this.createCamelContext();
        THREAD_CAMEL_CONTEXT.set(this.context);
        Assertions.assertNotNull((Object)this.context, (String)"No context found!");
        this.bindToRegistry(this.context.getRegistry());
        this.context.getShutdownStrategy().setTimeout((long)this.getShutdownTimeout());
        if (this.isUseDebugger()) {
            if (this.context.getStatus().equals((Object)ServiceStatus.Started)) {
                this.log.info("Cannot setting the Debugger to the starting CamelContext, stop the CamelContext now.");
                this.context.stop();
            }
            this.context.setDebugging(Boolean.valueOf(true));
            this.context.setDebugger((Debugger)new DefaultDebugger());
            this.context.getDebugger().addBreakpoint((Breakpoint)this.breakpoint);
        }
        ((SedaComponent)this.context.getComponent("seda", SedaComponent.class)).setDefaultPollTimeout(10);
        this.template = this.context.createProducerTemplate();
        this.template.start();
        this.fluentTemplate = this.context.createFluentProducerTemplate();
        this.fluentTemplate.start();
        this.consumer = this.context.createConsumerTemplate();
        this.consumer.start();
        THREAD_TEMPLATE.set(this.template);
        THREAD_FLUENT_TEMPLATE.set(this.fluentTemplate);
        THREAD_CONSUMER.set(this.consumer);
        String pattern = this.isMockEndpoints();
        if (pattern != null) {
            this.context.getCamelContextExtension().registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern));
        }
        if ((pattern = this.isMockEndpointsAndSkip()) != null) {
            this.context.getCamelContextExtension().registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern, true));
        }
        PropertiesComponent pc = this.context.getPropertiesComponent();
        if (this.extra == null) {
            this.extra = this.useOverridePropertiesWithPropertiesComponent();
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            pc.setOverrideProperties(this.extra);
        }
        pc.addPropertiesSource(new PropertiesSource(){

            public String getName() {
                return "junit-store";
            }

            public String getProperty(String name) {
                return (String)ContextTestSupport.this.getContextStore().get((Object)name, String.class);
            }
        });
        Boolean ignore = this.ignoreMissingLocationWithPropertiesComponent();
        if (ignore != null) {
            pc.setIgnoreMissingLocation(ignore.booleanValue());
        }
        String include = this.getRouteFilterIncludePattern();
        String exclude = this.getRouteFilterExcludePattern();
        if (include != null || exclude != null) {
            this.log.info("Route filtering pattern: include={}, exclude={}", (Object)include, (Object)exclude);
            ((Model)this.context.getCamelContextExtension().getContextPlugin(Model.class)).setRouteFilterPattern(include, exclude);
        }
        if (this.isUseRouteBuilder()) {
            RoutesBuilder[] builders;
            for (RoutesBuilder builder : builders = this.createRouteBuilders()) {
                if (!(builder instanceof RouteConfigurationsBuilder)) continue;
                RouteConfigurationsBuilder routeConfigurationsBuilder = (RouteConfigurationsBuilder)builder;
                this.log.debug("Using created route configuration: {}", (Object)builder);
                this.context.addRoutesConfigurations(routeConfigurationsBuilder);
            }
            for (RoutesBuilder builder : builders) {
                this.log.debug("Using created route builder to add routes: {}", (Object)builder);
                this.context.addRoutes(builder);
            }
            for (RoutesBuilder builder : builders) {
                this.log.debug("Using created route builder to add templated routes: {}", (Object)builder);
                this.context.addTemplatedRoutes(builder);
            }
            this.replaceFromEndpoints();
            boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
            if (skip) {
                this.log.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
            } else if (this.isUseAdviceWith()) {
                this.log.info("Skipping starting CamelContext as isUseAdviceWith is set to true.");
            } else {
                this.startCamelContext();
            }
        } else {
            this.replaceFromEndpoints();
            this.log.debug("Using route builder from the created context: {}", (Object)this.context);
        }
        this.log.debug("Routing Rules are: {}", (Object)this.context.getRoutes());
        this.assertValidContext((CamelContext)this.context);
        this.postProcessTest();
    }

    private void replaceFromEndpoints() throws Exception {
        for (final Map.Entry<String, String> entry : this.fromEndpoints.entrySet()) {
            AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition(entry.getKey()), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() {
                    this.replaceFromWith((String)entry.getValue());
                }
            });
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        long time = this.watch.taken();
        this.log.info(SEPARATOR);
        this.log.info("Testing done: {} ({})", (Object)this.getCurrentTestName(), (Object)this.getClass().getName());
        this.log.info("Took: {} ({} millis)", (Object)TimeUtils.printDuration((long)time, (boolean)true), (Object)time);
        this.log.info(SEPARATOR);
        this.log.debug("tearDown()");
        ContextTestSupport.doStopTemplates(this.consumer, this.template, this.fluentTemplate);
        this.doStopCamelContext((CamelContext)this.context, this.camelContextService);
        this.doPostTearDown();
        this.cleanupResources();
    }

    protected void doPostTearDown() {
    }

    protected void setupResources() {
    }

    protected void cleanupResources() {
    }

    protected int getShutdownTimeout() {
        return 10;
    }

    protected boolean useJmx() {
        return false;
    }

    protected boolean isLoadTypeConverters() {
        return true;
    }

    protected Properties useOverridePropertiesWithPropertiesComponent() {
        return null;
    }

    protected Boolean ignoreMissingLocationWithPropertiesComponent() {
        return null;
    }

    protected void postProcessTest() throws Exception {
        this.context = THREAD_CAMEL_CONTEXT.get();
        this.template = THREAD_TEMPLATE.get();
        this.fluentTemplate = THREAD_FLUENT_TEMPLATE.get();
        this.consumer = THREAD_CONSUMER.get();
        this.camelContextService = THREAD_SERVICE.get();
        if (this.isApplyCamelPostProcessor()) {
            this.applyCamelPostProcessor();
        }
    }

    protected void applyCamelPostProcessor() throws Exception {
        boolean spring = this.hasClassAnnotation("org.springframework.boot.test.context.SpringBootTest", "org.springframework.context.annotation.ComponentScan");
        if (!spring) {
            PluginHelper.getBeanPostProcessor((CamelContext)this.context).postProcessBeforeInitialization((Object)this, this.getClass().getName());
            PluginHelper.getBeanPostProcessor((CamelContext)this.context).postProcessAfterInitialization((Object)this, this.getClass().getName());
        }
    }

    protected boolean hasClassAnnotation(String ... names) {
        for (String name : names) {
            for (Annotation ann : this.getClass().getAnnotations()) {
                String annName = ann.annotationType().getName();
                if (!annName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected void stopCamelContext() {
        this.doStopCamelContext((CamelContext)this.context, this.camelContextService);
    }

    protected void doStopCamelContext(CamelContext context, Service camelContextService) {
        if (camelContextService != null) {
            if (camelContextService == THREAD_SERVICE.get()) {
                THREAD_SERVICE.remove();
            }
            camelContextService.stop();
        } else if (context != null) {
            if (context == THREAD_CAMEL_CONTEXT.get()) {
                THREAD_CAMEL_CONTEXT.remove();
            }
            context.stop();
        }
    }

    private static void doStopTemplates(ConsumerTemplate consumer, ProducerTemplate template, FluentProducerTemplate fluentTemplate) {
        if (consumer != null) {
            if (consumer == THREAD_CONSUMER.get()) {
                THREAD_CONSUMER.remove();
            }
            consumer.stop();
        }
        if (template != null) {
            if (template == THREAD_TEMPLATE.get()) {
                THREAD_TEMPLATE.remove();
            }
            template.stop();
        }
        if (fluentTemplate != null) {
            if (fluentTemplate == THREAD_FLUENT_TEMPLATE.get()) {
                THREAD_FLUENT_TEMPLATE.remove();
            }
            fluentTemplate.stop();
        }
    }

    protected void startCamelContext() {
        if (this.camelContextService != null) {
            this.camelContextService.start();
        } else {
            ModelCamelContext modelCamelContext = this.context;
            if (modelCamelContext instanceof DefaultCamelContext) {
                DefaultCamelContext defaultCamelContext = (DefaultCamelContext)modelCamelContext;
                if (!defaultCamelContext.isStarted()) {
                    defaultCamelContext.start();
                }
            } else {
                this.context.start();
            }
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        Registry registry = this.createCamelRegistry();
        DefaultCamelContext retContext = registry != null ? new DefaultCamelContext(registry) : new DefaultCamelContext();
        retContext.setLoadTypeConverters(Boolean.valueOf(this.isLoadTypeConverters()));
        return retContext;
    }

    protected Context createJndiContext() throws Exception {
        return JndiTest.createInitialContext();
    }

    protected void bindToRegistry(Registry registry) {
    }

    protected Registry createCamelRegistry() throws Exception {
        return new DefaultRegistry();
    }

    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RoutesBuilder[] createRouteBuilders() throws Exception {
        return new RoutesBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return TestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return TestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.getMockEndpoint(uri, true);
    }

    protected MockEndpoint getMockEndpoint(String uri, boolean create) throws NoSuchEndpointException {
        String n;
        try {
            n = URISupport.normalizeUri((String)uri);
        }
        catch (URISyntaxException e2) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e2);
        }
        String target = StringHelper.before((String)n, (String)"?", (String)n);
        MockEndpoint found = this.context.getEndpointRegistry().values().stream().filter(e -> e instanceof MockEndpoint).filter(e -> {
            String t = e.getEndpointUri();
            int idx2 = t.indexOf(63);
            if (idx2 != -1) {
                t = t.substring(0, idx2);
            }
            return t.equals(target);
        }).findFirst().orElse(null);
        if (found != null) {
            return found;
        }
        if (create) {
            return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
        }
        throw new NoSuchEndpointException(String.format("MockEndpoint %s does not exist.", uri));
    }

    protected void sendBody(String endpointUri, Object body) {
        this.template.send(endpointUri, exchange -> {
            Message in = exchange.getIn();
            in.setBody(body);
        });
    }

    protected void sendBody(String endpointUri, Object body, Map<String, Object> headers) {
        this.template.send(endpointUri, exchange -> {
            Message in = exchange.getIn();
            in.setBody(body);
            for (Map.Entry entry : headers.entrySet()) {
                in.setHeader((String)entry.getKey(), entry.getValue());
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return this.createExchangeWithBody((CamelContext)this.context, body);
    }

    protected void resetMocks() {
        MockEndpoint.resetMocks((CamelContext)this.context);
    }

    protected void assertMockEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context);
    }

    protected void assertMockEndpointsSatisfied(long timeout, TimeUnit unit) throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context, (long)timeout, (TimeUnit)unit);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression expression = language.createExpression(expressionText);
        Assertions.assertNotNull((Object)expression, (String)("No Expression could be created for text: " + expressionText + " language: " + String.valueOf(language)));
        TestSupport.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate predicate = language.createPredicate(expressionText);
        Assertions.assertNotNull((Object)predicate, (String)("No Predicate could be created for text: " + expressionText + " language: " + String.valueOf(language)));
        TestSupport.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = this.context.resolveLanguage(languageName);
        Assertions.assertNotNull((Object)language, (String)("No language found for name: " + languageName));
        return language;
    }

    protected void assertValidContext(CamelContext context) {
        Assertions.assertNotNull((Object)context, (String)"No context found!");
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        Endpoint endpoint = this.context.getEndpoint(uri, type);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for uri: " + uri));
        return (T)endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = this.context.getEndpoint(uri);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for uri: " + uri));
        return endpoint;
    }

    protected void disableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)true);
    }

    protected void enableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)false);
    }

    protected void debugBefore(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label) {
    }

    protected void debugAfter(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label, long timeTaken) {
    }

    protected NotifyBuilder event() {
        return new NotifyBuilder((CamelContext)this.context);
    }

    private class DebugBreakpoint
    extends BreakpointSupport {
        private DebugBreakpoint() {
        }

        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            ContextTestSupport.this.debugBefore(exchange, processor, (ProcessorDefinition)definition, definition.getId(), definition.getLabel());
        }

        public void afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
            ContextTestSupport.this.debugAfter(exchange, processor, (ProcessorDefinition)definition, definition.getId(), definition.getLabel(), timeTaken);
        }
    }
}

