/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Predicate;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfiguration;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfigurationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelParallelExecutionStrategy
implements ParallelExecutionConfigurationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CamelParallelExecutionStrategy.class);
    private static final String CONFIG_CUSTOM_PARALLELISM_PROPERTY_NAME = "custom.parallelism";
    private static final String CONFIG_CUSTOM_MAXPOOLSIZE_PROPERTY_NAME = "custom.maxPoolSize";
    private static final int DEFAULT_PARALLELISM = 2;
    int nbParallelExecutions;
    int maxPoolSize;

    public ParallelExecutionConfiguration createConfiguration(ConfigurationParameters configurationParameters) {
        Optional parallelism = configurationParameters.get(CONFIG_CUSTOM_PARALLELISM_PROPERTY_NAME, Integer::valueOf);
        this.nbParallelExecutions = parallelism.orElse(2);
        Optional poolSize = configurationParameters.get(CONFIG_CUSTOM_MAXPOOLSIZE_PROPERTY_NAME, Integer::valueOf);
        this.maxPoolSize = poolSize.orElseGet(() -> this.nbParallelExecutions * 256);
        LOG.info("Using custom JUnit parallel execution with parallelism={} and maxPoolSize={}", (Object)this.nbParallelExecutions, (Object)this.maxPoolSize);
        return new CamelParallelExecutionConfiguration();
    }

    private class CamelParallelExecutionConfiguration
    implements ParallelExecutionConfiguration {
        private CamelParallelExecutionConfiguration() {
        }

        public int getParallelism() {
            return CamelParallelExecutionStrategy.this.nbParallelExecutions;
        }

        public int getMinimumRunnable() {
            return CamelParallelExecutionStrategy.this.nbParallelExecutions;
        }

        public int getMaxPoolSize() {
            return CamelParallelExecutionStrategy.this.maxPoolSize;
        }

        public int getCorePoolSize() {
            return CamelParallelExecutionStrategy.this.nbParallelExecutions;
        }

        public int getKeepAliveSeconds() {
            return 30;
        }

        public Predicate<? super ForkJoinPool> getSaturatePredicate() {
            return pool -> {
                LOG.info("Junit ForkJoinPool saturated: running threads={}, pool size={}, queued tasks={}", new Object[]{pool.getRunningThreadCount(), pool.getPoolSize(), pool.getQueuedTaskCount()});
                return true;
            };
        }
    }
}

