/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelExceptionsTest
extends ContextTestSupport {
    @Test
    public void testExpectedBodyTypeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ExpectedBodyTypeException e = new ExpectedBodyTypeException((Exchange)exchange, Integer.class);
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        Assertions.assertEquals(Integer.class, (Object)e.getExpectedBodyType());
    }

    @Test
    public void testExpressionEvaluationException() {
        Expression exp = ExpressionBuilder.constantExpression((Object)"foo");
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ExpressionEvaluationException e = new ExpressionEvaluationException(exp, (Exchange)exchange, (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        Assertions.assertSame((Object)exp, (Object)e.getExpression());
        Assertions.assertNotNull((Object)e.getCause());
    }

    @Test
    public void testFailedToCreateConsumerException() {
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        FailedToCreateConsumerException e = new FailedToCreateConsumerException(endpoint, (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertEquals((Object)endpoint.getEndpointUri(), (Object)e.getUri());
        Assertions.assertNotNull((Object)e.getCause());
    }

    @Test
    public void testFailedToCreateProducerException() {
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        FailedToCreateProducerException e = new FailedToCreateProducerException(endpoint, (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertEquals((Object)endpoint.getEndpointUri(), (Object)e.getUri());
        Assertions.assertNotNull((Object)e.getCause());
    }

    @Test
    public void testInvalidPayloadRuntimeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        InvalidPayloadRuntimeException e = new InvalidPayloadRuntimeException((Exchange)exchange, Integer.class);
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        Assertions.assertEquals(Integer.class, (Object)e.getType());
        InvalidPayloadRuntimeException e2 = new InvalidPayloadRuntimeException((Exchange)exchange, Integer.class, exchange.getIn());
        Assertions.assertSame((Object)exchange, (Object)e2.getExchange());
        Assertions.assertEquals(Integer.class, (Object)e2.getType());
        InvalidPayloadRuntimeException e3 = new InvalidPayloadRuntimeException((Exchange)exchange, Integer.class, exchange.getIn(), (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertSame((Object)exchange, (Object)e3.getExchange());
        Assertions.assertEquals(Integer.class, (Object)e3.getType());
    }

    @Test
    public void testRuntimeTransformException() {
        RuntimeTransformException e = new RuntimeTransformException("Forced");
        Assertions.assertEquals((Object)"Forced", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        RuntimeTransformException e2 = new RuntimeTransformException("Forced", (Throwable)new IllegalAccessException("Damn"));
        Assertions.assertEquals((Object)"Forced", (Object)e2.getMessage());
        Assertions.assertNotNull((Object)e2.getCause());
        RuntimeTransformException e3 = new RuntimeTransformException((Throwable)new IllegalAccessException("Damn"));
        Assertions.assertEquals((Object)"java.lang.IllegalAccessException: Damn", (Object)e3.getMessage());
        Assertions.assertNotNull((Object)e3.getCause());
    }

    @Test
    public void testRuntimeExpressionException() {
        RuntimeExpressionException e = new RuntimeExpressionException("Forced");
        Assertions.assertEquals((Object)"Forced", (Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
        RuntimeExpressionException e2 = new RuntimeExpressionException("Forced", (Throwable)new IllegalAccessException("Damn"));
        Assertions.assertEquals((Object)"Forced", (Object)e2.getMessage());
        Assertions.assertNotNull((Object)e2.getCause());
        RuntimeExpressionException e3 = new RuntimeExpressionException((Throwable)new IllegalAccessException("Damn"));
        Assertions.assertEquals((Object)"java.lang.IllegalAccessException: Damn", (Object)e3.getMessage());
        Assertions.assertNotNull((Object)e3.getCause());
    }

    @Test
    public void testRollbackExchangeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        RollbackExchangeException e = new RollbackExchangeException((Exchange)exchange, (Throwable)new IllegalAccessException("Damn"));
        Assertions.assertNotNull((Object)e.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        RollbackExchangeException e2 = new RollbackExchangeException("Forced", (Exchange)exchange, (Throwable)new IllegalAccessException("Damn"));
        Assertions.assertNotNull((Object)e2.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e2.getExchange());
    }

    @Test
    public void testValidationException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ValidationException e = new ValidationException((Exchange)exchange, "Forced");
        Assertions.assertNotNull((Object)e.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        ValidationException e2 = new ValidationException("Forced", (Exchange)exchange, (Throwable)new IllegalAccessException("Damn"));
        Assertions.assertNotNull((Object)e2.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e2.getExchange());
    }

    @Test
    public void testNoSuchBeanException() {
        NoSuchBeanException e = new NoSuchBeanException("foo");
        Assertions.assertEquals((Object)"foo", (Object)e.getName());
        Assertions.assertNull((Object)e.getCause());
        NoSuchBeanException e2 = new NoSuchBeanException("foo", (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertEquals((Object)"foo", (Object)e2.getName());
        Assertions.assertNotNull((Object)e2.getCause());
    }

    @Test
    public void testCamelExecutionException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        CamelExecutionException e = new CamelExecutionException("Forced", (Exchange)exchange);
        Assertions.assertNotNull((Object)e.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        Assertions.assertNull((Object)e.getCause());
        CamelExecutionException e2 = new CamelExecutionException("Forced", (Exchange)exchange, (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertNotNull((Object)e2.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e2.getExchange());
        Assertions.assertNotNull((Object)e2.getCause());
    }

    @Test
    public void testCamelException() {
        CamelException e = new CamelException();
        Assertions.assertNull((Object)e.getCause());
        CamelException e2 = new CamelException("Forced");
        Assertions.assertNull((Object)e2.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)e2.getMessage());
        CamelException e3 = new CamelException("Forced", (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertNotNull((Object)e3.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)e3.getMessage());
        CamelException e4 = new CamelException((Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertNotNull((Object)e4.getCause());
        Assertions.assertNotNull((Object)e4.getMessage());
    }

    @Test
    public void testServiceStatus() {
        Assertions.assertTrue((boolean)ServiceStatus.Started.isStarted());
        Assertions.assertFalse((boolean)ServiceStatus.Starting.isStarted());
        Assertions.assertFalse((boolean)ServiceStatus.Starting.isStoppable());
        Assertions.assertFalse((boolean)ServiceStatus.Stopped.isStarted());
        Assertions.assertFalse((boolean)ServiceStatus.Stopping.isStarted());
        Assertions.assertTrue((boolean)ServiceStatus.Stopped.isStopped());
        Assertions.assertFalse((boolean)ServiceStatus.Starting.isStopped());
        Assertions.assertFalse((boolean)ServiceStatus.Started.isStopped());
        Assertions.assertFalse((boolean)ServiceStatus.Stopping.isStopped());
        Assertions.assertTrue((boolean)ServiceStatus.Stopped.isStartable());
        Assertions.assertFalse((boolean)ServiceStatus.Started.isStartable());
        Assertions.assertFalse((boolean)ServiceStatus.Starting.isStartable());
        Assertions.assertFalse((boolean)ServiceStatus.Stopping.isStartable());
        Assertions.assertTrue((boolean)ServiceStatus.Started.isStoppable());
        Assertions.assertFalse((boolean)ServiceStatus.Starting.isStoppable());
        Assertions.assertFalse((boolean)ServiceStatus.Stopped.isStoppable());
        Assertions.assertFalse((boolean)ServiceStatus.Stopping.isStoppable());
    }

    @Test
    public void testRuntimeExchangeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        RuntimeExchangeException e = new RuntimeExchangeException("Forced", (Exchange)exchange);
        Assertions.assertNotNull((Object)e.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        RuntimeExchangeException e2 = new RuntimeExchangeException("Forced", null);
        Assertions.assertNotNull((Object)e2.getMessage());
        Assertions.assertNull((Object)e2.getExchange());
    }

    @Test
    public void testExchangePattern() {
        Assertions.assertTrue((boolean)ExchangePattern.InOnly.isInCapable());
        Assertions.assertTrue((boolean)ExchangePattern.InOut.isInCapable());
        Assertions.assertFalse((boolean)ExchangePattern.InOnly.isOutCapable());
        Assertions.assertTrue((boolean)ExchangePattern.InOut.isOutCapable());
        Assertions.assertEquals((Object)ExchangePattern.InOnly, (Object)ExchangePattern.asEnum((String)"InOnly"));
        Assertions.assertEquals((Object)ExchangePattern.InOut, (Object)ExchangePattern.asEnum((String)"InOut"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ExchangePattern.asEnum((String)"foo"), (String)"Should have thrown an exception");
    }

    @Test
    public void testInvalidPayloadException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        InvalidPayloadException e = new InvalidPayloadException((Exchange)exchange, Integer.class);
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        Assertions.assertEquals(Integer.class, (Object)e.getType());
    }

    @Test
    public void testExchangeTimedOutException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ExchangeTimedOutException e = new ExchangeTimedOutException((Exchange)exchange, 5000L);
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
        Assertions.assertEquals((long)5000L, (long)e.getTimeout());
    }

    @Test
    public void testExpressionIllegalSyntaxException() {
        ExpressionIllegalSyntaxException e = new ExpressionIllegalSyntaxException("foo");
        Assertions.assertEquals((Object)"foo", (Object)e.getExpression());
    }

    @Test
    public void testNoFactoryAvailableException() {
        NoFactoryAvailableException e = new NoFactoryAvailableException("killer", (Throwable)new IllegalArgumentException("Damn"));
        Assertions.assertNotNull((Object)e.getCause());
        Assertions.assertEquals((Object)"killer", (Object)e.getUri());
    }

    @Test
    public void testCamelExchangeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        CamelExchangeException e = new CamelExchangeException("Forced", (Exchange)exchange);
        Assertions.assertNotNull((Object)e.getMessage());
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
    }

    @Test
    public void testNoSuchHeaderException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        NoSuchHeaderException e = new NoSuchHeaderException((Exchange)exchange, "foo", Integer.class);
        Assertions.assertEquals(Integer.class, (Object)e.getType());
        Assertions.assertEquals((Object)"foo", (Object)e.getHeaderName());
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
    }

    @Test
    public void testNoSuchPropertyException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        NoSuchPropertyException e = new NoSuchPropertyException((Exchange)exchange, "foo", Integer.class);
        Assertions.assertEquals(Integer.class, (Object)e.getType());
        Assertions.assertEquals((Object)"foo", (Object)e.getPropertyName());
        Assertions.assertSame((Object)exchange, (Object)e.getExchange());
    }

    @Test
    public void testRuntimeCamelException() {
        RuntimeCamelException e = new RuntimeCamelException();
        Assertions.assertNull((Object)e.getMessage());
        Assertions.assertNull((Object)e.getCause());
    }

    @Test
    public void testFailedToStartRouteException() {
        FailedToStartRouteException e = new FailedToStartRouteException("myRoute", "Forced error", (Throwable)new IllegalArgumentException("Forced"));
        Assertions.assertNotNull((Object)e.getMessage());
        CamelExceptionsTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
    }

    @Test
    public void testNoTypeConversionAvailableException() {
        NoTypeConversionAvailableException e = new NoTypeConversionAvailableException((Object)"foo", Date.class);
        Assertions.assertEquals((Object)"foo", (Object)e.getValue());
        Assertions.assertEquals(Date.class, (Object)e.getToType());
        Assertions.assertEquals(String.class, (Object)e.getFromType());
        NoTypeConversionAvailableException e2 = new NoTypeConversionAvailableException(null, Date.class);
        Assertions.assertNull((Object)e2.getValue());
        Assertions.assertEquals(Date.class, (Object)e2.getToType());
        Assertions.assertNull((Object)e2.getFromType());
    }

    @Test
    public void testResolveEndpointFailedException() {
        ResolveEndpointFailedException e = new ResolveEndpointFailedException("foo:bar");
        Assertions.assertEquals((Object)"foo:bar", (Object)e.getUri());
    }
}

