/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AutoCloseableTest {
    @Test
    public void servicesShouldBeAutoCloseable() throws Exception {
        DefaultCamelContext usedContext = null;
        ProducerTemplate usedProducer = null;
        try (DefaultCamelContext context = new DefaultCamelContext();
             ProducerTemplate producer = context.createProducerTemplate();){
            usedContext = context;
            usedProducer = producer;
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").log("hello ${body}");
                }
            });
            context.start();
            producer.sendBody("direct:start", (Object)"word");
        }
        Assertions.assertThat((boolean)usedContext.isStopped()).isTrue();
        Assertions.assertThat((boolean)((DefaultProducerTemplate)usedProducer).isStopped()).isTrue();
    }
}

