/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.commands.crsh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.commands.AbstractLocalCamelController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class CamelControllerImpl
extends AbstractLocalCamelController {
    private static final Logger LOG = LoggerFactory.getLogger(CamelControllerImpl.class);
    private ListableBeanFactory beanFactory;

    CamelControllerImpl(ListableBeanFactory factory) {
        this.beanFactory = factory;
    }

    public List<CamelContext> getLocalCamelContexts() {
        ArrayList<CamelContext> camelContexts = new ArrayList<CamelContext>();
        try {
            camelContexts.addAll(this.beanFactory.getBeansOfType(CamelContext.class).values());
        }
        catch (Exception e) {
            LOG.warn("Cannot retrieve the list of Camel contexts.", (Throwable)e);
        }
        Collections.sort(camelContexts, new Comparator<CamelContext>(){

            @Override
            public int compare(CamelContext o1, CamelContext o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return camelContexts;
    }

    public List<Map<String, String>> getCamelContexts() throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        List<CamelContext> camelContexts = this.getLocalCamelContexts();
        for (CamelContext camelContext : camelContexts) {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            row.put("name", camelContext.getName());
            row.put("state", camelContext.getStatus().name());
            row.put("uptime", camelContext.getUptime());
            if (camelContext.getManagedCamelContext() != null) {
                row.put("exchangesTotal", "" + camelContext.getManagedCamelContext().getExchangesTotal());
                row.put("exchangesInflight", "" + camelContext.getManagedCamelContext().getExchangesInflight());
                row.put("exchangesFailed", "" + camelContext.getManagedCamelContext().getExchangesFailed());
            } else {
                row.put("exchangesTotal", "0");
                row.put("exchangesInflight", "0");
                row.put("exchangesFailed", "0");
            }
            answer.add(row);
        }
        return answer;
    }
}

