/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.commands.crsh;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.AbstractRouteCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.LocalCamelController;
import org.apache.camel.commands.StringEscape;
import org.apache.camel.springboot.commands.crsh.NoopStringEscape;
import org.apache.camel.springboot.commands.crsh.OutputBuffer;
import org.crsh.cli.impl.SyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelCommandsFacade {
    protected final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private LocalCamelController camelController;
    private StringEscape stringEscape = new NoopStringEscape();

    CamelCommandsFacade(LocalCamelController controller) {
        this.camelController = controller;
    }

    LocalCamelController getCamelController() {
        return this.camelController;
    }

    public <T extends AbstractCamelCommand> String runCommand(Class<T> clazz, Object ... commandArgs) throws Exception {
        OutputBuffer buffer = new OutputBuffer();
        PrintStream ops = buffer.getPrintStream();
        if (AbstractRouteCommand.class.isAssignableFrom(clazz) && null == commandArgs[1]) {
            commandArgs[1] = this.getCamelContextForRoute((String)commandArgs[0]);
            ops.println("Automatically inferred context name : " + commandArgs[1]);
        }
        if (AbstractContextCommand.class.isAssignableFrom(clazz) && null == commandArgs[0]) {
            commandArgs[0] = this.getFirstCamelContextName();
            ops.println("Context name is not provided. Using the first : " + commandArgs[0]);
        }
        Class[] types = new Class[commandArgs.length];
        for (int i = 0; i < commandArgs.length; ++i) {
            types[i] = commandArgs[i].getClass();
            if (types[i] == Boolean.class) {
                types[i] = Boolean.TYPE;
            }
            if (types[i] != Integer.class) continue;
            types[i] = Integer.TYPE;
        }
        Constructor<T> constructor = clazz.getConstructor(types);
        AbstractCamelCommand command = (AbstractCamelCommand)constructor.newInstance(commandArgs);
        try {
            Method m = clazz.getMethod("setStringEscape", StringEscape.class);
            m.invoke((Object)command, this.stringEscape);
        }
        catch (Exception exception) {
            // empty catch block
        }
        command.execute((CamelController)this.camelController, ops, ops);
        return buffer.toString();
    }

    private String getCamelContextForRoute(String routeId) throws Exception {
        ArrayList<String> contextNames = new ArrayList<String>();
        block0: for (CamelContext camelContext : this.camelController.getLocalCamelContexts()) {
            for (Route route : camelContext.getRoutes()) {
                if (!routeId.equals(route.getId())) continue;
                contextNames.add(camelContext.getName());
                continue block0;
            }
        }
        if (contextNames.size() != 1) {
            StringBuffer error = new StringBuffer();
            error.append("Cannot infer CamelContext. Please provide manually.");
            if (contextNames.size() > 1) {
                error.append(" Contexts : " + contextNames.toString());
            }
            throw new SyntaxException(error.toString());
        }
        return (String)contextNames.get(0);
    }

    private String getFirstCamelContextName() throws Exception {
        if (this.camelController.getLocalCamelContexts() == null || this.camelController.getLocalCamelContexts().size() == 0) {
            throw new SyntaxException("No CamelContexts available");
        }
        return ((CamelContext)this.camelController.getLocalCamelContexts().get(0)).getName();
    }
}

