/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.commands.crsh;

import java.util.LinkedList;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.commands.LocalCamelController;
import org.apache.camel.springboot.commands.crsh.ArgumentCamelContext;
import org.apache.camel.springboot.commands.crsh.ArgumentRouteID;
import org.apache.camel.springboot.commands.crsh.CamelCommandsPlugin;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.spi.Completion;

public class CamelCompleter
implements Completer {
    private LocalCamelController camelController = CamelCommandsPlugin.getInstance().getCamelCommandsFacade().getCamelController();

    public Completion complete(ParameterDescriptor parameterDescriptor, String prefix) throws Exception {
        LinkedList<String> values = new LinkedList<String>();
        Completion.Builder builder = new Completion.Builder(prefix);
        if (parameterDescriptor.getAnnotation() instanceof ArgumentCamelContext) {
            values.addAll(this.getContextNames());
        }
        if (parameterDescriptor.getAnnotation() instanceof ArgumentRouteID) {
            values.addAll(this.getRouteIds());
        }
        for (String value : values) {
            if (!value.startsWith(prefix)) continue;
            builder.add(value.substring(prefix.length()), true);
        }
        return builder.build();
    }

    private LinkedList<String> getContextNames() throws Exception {
        LinkedList<String> values = new LinkedList<String>();
        for (CamelContext camelContext : this.camelController.getLocalCamelContexts()) {
            values.add(camelContext.getName());
        }
        return values;
    }

    private LinkedList<String> getRouteIds() throws Exception {
        LinkedList<String> values = new LinkedList<String>();
        for (CamelContext camelContext : this.camelController.getLocalCamelContexts()) {
            for (Route route : camelContext.getRoutes()) {
                values.add(route.getId());
            }
        }
        return values;
    }
}

