/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.internal.MatchUtil;
import org.apache.camel.commands.internal.RegexUtil;
import org.apache.camel.support.JSonSchemaHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractCamelController
implements CamelController {
    @Override
    public List<Map<String, String>> getCamelContexts(String filter) throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        List<Map<String, String>> context = this.getCamelContexts();
        filter = filter != null ? RegexUtil.wildcardAsRegex(filter) : "*";
        for (Map<String, String> entry : context) {
            String name = entry.get("name");
            if (!name.equalsIgnoreCase(filter) && !MatchUtil.matchWildcard(name, filter) && !name.matches(filter)) continue;
            answer.add(entry);
        }
        return answer;
    }

    protected Map<String, Object> loadProperties(String json, String group, Map<String, Object> answer) {
        List kv = JSonSchemaHelper.parseJsonSchema((String)group, (String)json, (boolean)true);
        if (kv.isEmpty()) {
            return answer;
        }
        LinkedHashMap groupkv = new LinkedHashMap();
        answer.put(group, groupkv);
        for (Map map : kv) {
            boolean first = true;
            LinkedHashMap properties = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                if (first) {
                    if (!ObjectHelper.equal(entry.getKey(), (Object)"name")) {
                        throw new IllegalStateException("First entry should be the property name");
                    }
                    groupkv.put(entry.getValue(), properties);
                    first = false;
                    continue;
                }
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return answer;
    }
}

