/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.LocalCamelController;

public abstract class AbstractContextCommand
extends AbstractCamelCommand {
    String context;

    protected AbstractContextCommand(String context) {
        this.context = context;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        if (camelController instanceof LocalCamelController) {
            return this.executeLocal((LocalCamelController)camelController, out, err);
        }
        boolean found = false;
        List<Map<String, String>> contexts = camelController.getCamelContexts();
        for (Map<String, String> entry : contexts) {
            String name = entry.get("name");
            if (!this.context.equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            err.println("Camel context " + this.context + " not found.");
            return null;
        }
        return this.performContextCommand(camelController, this.context, out, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeLocal(LocalCamelController camelController, PrintStream out, PrintStream err) throws Exception {
        CamelContext camelContext = camelController.getLocalCamelContext(this.context);
        if (camelContext == null) {
            err.println("Camel context " + this.context + " not found.");
            return null;
        }
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(camelContext.getApplicationContextClassLoader());
        try {
            Object object = this.performContextCommand(camelController, camelContext.getName(), out, err);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    protected abstract Object performContextCommand(CamelController var1, String var2, PrintStream var3, PrintStream var4) throws Exception;
}

