/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.coap.CoAPHelper;
import org.apache.camel.support.DefaultConsumer;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapResponse;

public class CoAPObserver
extends DefaultConsumer
implements CoapHandler {
    private final CoAPEndpoint endpoint;
    private CoapClient client;

    public CoAPObserver(CoAPEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.client == null) {
            this.client = this.endpoint.createCoapClient(this.endpoint.getUri());
        }
        this.startObserve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(CoapResponse response) {
        Exchange camelExchange = this.createExchange(false);
        try {
            CoAPHelper.convertCoapResponseToMessage(response, camelExchange.getMessage());
            this.getProcessor().process(camelExchange);
        }
        catch (Exception exception) {
        }
        finally {
            exception = camelExchange.getException();
            if (exception != null) {
                this.getExceptionHandler().handleException("Error processing observed update", camelExchange, (Throwable)exception);
            }
            this.releaseExchange(camelExchange, false);
        }
    }

    public void onError() {
        this.getExceptionHandler().handleException((Throwable)new IOException("CoAP request timed out or has been rejected by the server"));
        this.startObserve();
    }

    private void startObserve() {
        this.client.observe((CoapHandler)this);
    }
}

