/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.tcp.TcpServerConnector;
import org.eclipse.californium.elements.tcp.TlsServerConnector;
import org.eclipse.californium.scandium.DTLSConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="coap,coaps,coap+tcp,coaps+tcp")
public class CoAPComponent
extends DefaultComponent
implements RestConsumerFactory {
    static final int DEFAULT_PORT = 5684;
    private static final Logger LOG = LoggerFactory.getLogger(CoAPComponent.class);
    final Map<Integer, CoapServer> servers = new ConcurrentHashMap<Integer, CoapServer>();

    public synchronized CoapServer getServer(int port, CoAPEndpoint endpoint) throws IOException, GeneralSecurityException {
        CoapServer server = this.servers.get(port);
        if (server == null && port == -1) {
            server = this.getServer(5684, endpoint);
        }
        if (server == null) {
            CoapEndpoint.Builder coapBuilder = new CoapEndpoint.Builder();
            NetworkConfig config = NetworkConfig.createStandardWithoutFile();
            InetSocketAddress address = new InetSocketAddress(port);
            coapBuilder.setNetworkConfig(config);
            if (CoAPEndpoint.enableDTLS(endpoint.getUri())) {
                DTLSConnector connector = endpoint.createDTLSConnector(address, false);
                coapBuilder.setConnector((Connector)connector);
            } else if (CoAPEndpoint.enableTCP(endpoint.getUri())) {
                int tcpThreads = config.getInt("TCP_WORKER_THREADS");
                int tcpIdleTimeout = config.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
                TcpServerConnector tcpConnector = null;
                if (endpoint.getUri().getScheme().startsWith("coaps")) {
                    int tlsHandshakeTimeout = config.getInt("TLS_HANDSHAKE_TIMEOUT");
                    SSLContext sslContext = endpoint.getSslContextParameters().createSSLContext(this.getCamelContext());
                    TlsServerConnector.ClientAuthMode clientAuthMode = TlsServerConnector.ClientAuthMode.NONE;
                    if (endpoint.isClientAuthenticationRequired()) {
                        clientAuthMode = TlsServerConnector.ClientAuthMode.NEEDED;
                    } else if (endpoint.isClientAuthenticationWanted()) {
                        clientAuthMode = TlsServerConnector.ClientAuthMode.WANTED;
                    }
                    tcpConnector = new TlsServerConnector(sslContext, clientAuthMode, address, tcpThreads, tlsHandshakeTimeout, tcpIdleTimeout);
                } else {
                    tcpConnector = new TcpServerConnector(address, tcpThreads, tcpIdleTimeout);
                }
                coapBuilder.setConnector((Connector)tcpConnector);
            } else {
                coapBuilder.setInetSocketAddress(address);
            }
            server = new CoapServer();
            server.addEndpoint((org.eclipse.californium.core.network.Endpoint)coapBuilder.build());
            this.servers.put(port, server);
            if (this.isStarted()) {
                server.start();
            }
        }
        return server;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CoAPEndpoint endpoint = new CoAPEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String contextPath;
        String host;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("coap", true);
        }
        if (config.isEnableCORS()) {
            LOG.info("CORS configuration will be ignored as CORS is not supported by the CoAP component");
        }
        if (ObjectHelper.isEmpty((Object)(host = config.getHost()))) {
            if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap map = new HashMap();
        if (config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        String scheme = config.getScheme() == null ? "coap" : config.getScheme();
        String query = URISupport.createQueryString(map);
        int port = 0;
        int num = config.getPort();
        if (num > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        String restrict = verb.toUpperCase(Locale.US);
        String url = String.format("%s://%s:%d/%s?coapMethodRestrict=%s", scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        CoAPEndpoint endpoint = (CoAPEndpoint)camelContext.getEndpoint(url, CoAPEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (CoapServer s : this.servers.values()) {
            s.start();
        }
    }

    protected void doStop() throws Exception {
        for (CoapServer s : this.servers.values()) {
            s.stop();
        }
        super.doStop();
    }
}

