/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.coap.CoAPHelper;
import org.apache.camel.impl.DefaultProducer;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.tcp.TcpClientConnector;
import org.eclipse.californium.elements.tcp.TlsClientConnector;
import org.eclipse.californium.scandium.DTLSConnector;

public class CoAPProducer
extends DefaultProducer {
    private final CoAPEndpoint endpoint;
    private CoapClient client;

    public CoAPProducer(CoAPEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Message resp;
        CoapClient client = this.getClient(exchange);
        String ct = (String)exchange.getIn().getHeader("Content-Type", String.class);
        if (ct == null) {
            ct = "application/octet-stream";
        }
        String method = CoAPHelper.getDefaultMethod(exchange, client);
        int mediaType = MediaTypeRegistry.parse((String)ct);
        CoapResponse response = null;
        boolean pingResponse = false;
        switch (method) {
            case "GET": {
                response = client.get();
                break;
            }
            case "DELETE": {
                response = client.delete();
                break;
            }
            case "POST": {
                byte[] bodyPost = (byte[])exchange.getIn().getBody(byte[].class);
                response = client.post(bodyPost, mediaType);
                break;
            }
            case "PUT": {
                byte[] bodyPut = (byte[])exchange.getIn().getBody(byte[].class);
                response = client.put(bodyPut, mediaType);
                break;
            }
            case "PING": {
                pingResponse = client.ping();
                break;
            }
        }
        if (response != null) {
            resp = exchange.getOut();
            String mt = MediaTypeRegistry.toString((int)response.getOptions().getContentFormat());
            resp.setHeader("Content-Type", (Object)mt);
            resp.setHeader("CamelCoapResponseCode", (Object)response.getCode().toString());
            resp.setBody((Object)response.getPayload());
        }
        if (method.equalsIgnoreCase("PING")) {
            resp = exchange.getOut();
            resp.setBody((Object)pingResponse);
        }
    }

    private synchronized CoapClient getClient(Exchange exchange) throws IOException, GeneralSecurityException {
        if (this.client == null) {
            URI uri = (URI)exchange.getIn().getHeader("CamelCoapUri", URI.class);
            if (uri == null) {
                uri = this.endpoint.getUri();
            }
            this.client = new CoapClient(uri);
            if (CoAPEndpoint.enableDTLS(uri)) {
                DTLSConnector connector = this.endpoint.createDTLSConnector(null, true);
                CoapEndpoint.Builder coapBuilder = new CoapEndpoint.Builder();
                coapBuilder.setConnector((Connector)connector);
                this.client.setEndpoint((org.eclipse.californium.core.network.Endpoint)coapBuilder.build());
            } else if (CoAPEndpoint.enableTCP(this.endpoint.getUri())) {
                NetworkConfig config = NetworkConfig.createStandardWithoutFile();
                int tcpThreads = config.getInt("TCP_WORKER_THREADS");
                int tcpConnectTimeout = config.getInt("TCP_CONNECT_TIMEOUT");
                int tcpIdleTimeout = config.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
                TcpClientConnector tcpConnector = null;
                if (this.endpoint.getUri().getScheme().startsWith("coaps")) {
                    SSLContext sslContext = this.endpoint.getSslContextParameters().createSSLContext(this.endpoint.getCamelContext());
                    tcpConnector = new TlsClientConnector(sslContext, tcpThreads, tcpConnectTimeout, tcpIdleTimeout);
                } else {
                    tcpConnector = new TcpClientConnector(tcpThreads, tcpConnectTimeout, tcpIdleTimeout);
                }
                CoapEndpoint.Builder tcpBuilder = new CoapEndpoint.Builder();
                tcpBuilder.setConnector((Connector)tcpConnector);
                this.client.setEndpoint((org.eclipse.californium.core.network.Endpoint)tcpBuilder.build());
            }
        }
        return this.client;
    }
}

