/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.coap.CoAPConsumer;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;

final class CamelCoapResource
extends CoapResource {
    private final Map<String, CoAPConsumer> consumers = new ConcurrentHashMap<String, CoAPConsumer>();
    private final List<CamelCoapResource> possibles;

    CamelCoapResource(String name, CoAPConsumer consumer) {
        super(name);
        this.consumers.put(consumer.getCoapEndpoint().getCoapMethod(), consumer);
        this.possibles = null;
    }

    private CamelCoapResource(String name, List<CamelCoapResource> possibles) {
        super(name);
        this.possibles = possibles;
    }

    void addConsumer(CoAPConsumer consumer) {
        this.consumers.put(consumer.getCoapEndpoint().getCoapMethod(), consumer);
    }

    public Resource getChild(String name) {
        Resource child;
        if (this.possibles != null) {
            // empty if block
        }
        if ((child = super.getChild(name)) == null) {
            LinkedList<CamelCoapResource> possibles = new LinkedList<CamelCoapResource>();
            for (Resource r : this.getChildren()) {
                if (!r.getName().startsWith("{") || !r.getName().endsWith("}")) continue;
                possibles.add((CamelCoapResource)r);
            }
            if (possibles.size() == 1) {
                return (Resource)possibles.get(0);
            }
            if (!possibles.isEmpty()) {
                return new CamelCoapResource(name, possibles);
            }
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(org.eclipse.californium.core.network.Exchange exchange) {
        CoAPConsumer consumer;
        Exchange camelExchange;
        block17: {
            block16: {
                camelExchange = null;
                consumer = null;
                if (this.possibles != null) {
                    this.consumers.putAll(this.possibles.get((int)0).consumers);
                }
                CoapExchange cexchange = new CoapExchange(exchange, (CoapResource)this);
                try {
                    CamelCoapResource r;
                    consumer = this.consumers.get(exchange.getRequest().getCode().name());
                    if (consumer == null) {
                        consumer = this.consumers.get("*");
                    }
                    if (consumer == null) {
                        cexchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
                        if (camelExchange == null) return;
                        break block16;
                    }
                    camelExchange = consumer.getEndpoint().createExchange();
                    consumer.createUoW(camelExchange);
                    OptionSet options = exchange.getRequest().getOptions();
                    for (String s : options.getUriQuery()) {
                        int i = s.indexOf(61);
                        if (i == -1) {
                            camelExchange.getIn().setHeader(s, (Object)"");
                            continue;
                        }
                        camelExchange.getIn().setHeader(s.substring(0, i), (Object)s.substring(i + 1));
                    }
                    if (options.hasContentFormat()) {
                        String mt = MediaTypeRegistry.toString((int)options.getContentFormat());
                        camelExchange.getIn().setHeader("Content-Type", (Object)mt);
                    }
                    List path = exchange.getRequest().getOptions().getUriPath();
                    LinkedList<CamelCoapResource> resources = new LinkedList<CamelCoapResource>();
                    for (r = this; r != null; r = r.getParent()) {
                        resources.push(r);
                    }
                    if (((Resource)resources.getFirst()).getName().isEmpty()) {
                        resources.removeFirst();
                    }
                    for (int res = 0; !resources.isEmpty() && res < path.size(); ++res) {
                        r = (Resource)resources.removeFirst();
                        if (r.getName().charAt(0) != '{' || r.getName().charAt(r.getName().length() - 1) != '}') continue;
                        String n = r.getName().substring(1, r.getName().length() - 1);
                        camelExchange.getIn().setHeader(n, path.get(res));
                    }
                    byte[] bytes = exchange.getCurrentRequest().getPayload();
                    camelExchange.getIn().setBody((Object)bytes);
                    consumer.getProcessor().process(camelExchange);
                    Message target = camelExchange.hasOut() ? camelExchange.getOut() : camelExchange.getIn();
                    int format = MediaTypeRegistry.parse((String)((String)target.getHeader("Content-Type", String.class)));
                    cexchange.respond(CoAP.ResponseCode.CONTENT, (byte[])target.getBody(byte[].class), format);
                    if (camelExchange == null) return;
                    break block17;
                }
                catch (Exception e) {
                    cexchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, e.getMessage());
                    return;
                }
            }
            consumer.doneUoW(camelExchange);
            return;
        }
        consumer.doneUoW(camelExchange);
        return;
        finally {
            if (camelExchange != null) {
                consumer.doneUoW(camelExchange);
            }
        }
    }
}

