/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.transaction;

import javax.annotation.Resource;
import javax.transaction.TransactionManager;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.cdi.transaction.JtaTransactionErrorHandler;
import org.apache.camel.cdi.transaction.JtaTransactionErrorHandlerBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.TransactedPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JtaTransactionPolicy
implements TransactedPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(JtaTransactionPolicy.class);
    @Resource(lookup="java:/TransactionManager")
    protected TransactionManager transactionManager;

    public void beforeWrap(Route route, NamedNode definition) {
        ((ProcessorDefinition)definition).setInheritErrorHandler(Boolean.valueOf(false));
    }

    public abstract void run(Runnable var1) throws Throwable;

    public Processor wrap(Route route, Processor processor) {
        JtaTransactionErrorHandlerBuilder txBuilder;
        ErrorHandlerBuilderRef builderRef;
        String ref;
        RouteDefinition routeDefinition = (RouteDefinition)route.getRoute();
        ErrorHandlerBuilder builder = (ErrorHandlerBuilder)routeDefinition.getErrorHandlerFactory();
        if (builder instanceof ErrorHandlerBuilderRef && ErrorHandlerReifier.isErrorHandlerFactoryConfigured((String)(ref = (builderRef = (ErrorHandlerBuilderRef)builder).getRef()))) {
            LOG.debug("Looking up ErrorHandlerBuilder with ref: {}", (Object)ref);
            builder = (ErrorHandlerBuilder)ErrorHandlerReifier.lookupErrorHandlerFactory((Route)route, (String)ref);
        }
        if (builder != null && builder.supportTransacted()) {
            if (!(builder instanceof JtaTransactionErrorHandlerBuilder)) {
                throw new RuntimeCamelException("The given transactional error handler builder '" + builder + "' is not of type '" + JtaTransactionErrorHandlerBuilder.class.getName() + "' which is required in this environment!");
            }
            LOG.debug("The ErrorHandlerBuilder configured is a JtaTransactionErrorHandlerBuilder: {}", (Object)builder);
            txBuilder = (JtaTransactionErrorHandlerBuilder)builder.cloneBuilder();
        } else {
            LOG.debug("No or no transactional ErrorHandlerBuilder configured, will use default JtaTransactionErrorHandlerBuilder settings");
            txBuilder = new JtaTransactionErrorHandlerBuilder();
        }
        txBuilder.setTransactionPolicy(this);
        if (builder != null) {
            route.addErrorHandlerFactoryReference((ErrorHandlerFactory)builder, (ErrorHandlerFactory)txBuilder);
        }
        JtaTransactionErrorHandler answer = this.createTransactionErrorHandler(route, processor, (ErrorHandlerBuilder)txBuilder);
        route.setErrorHandlerFactory((ErrorHandlerFactory)txBuilder);
        return answer;
    }

    protected JtaTransactionErrorHandler createTransactionErrorHandler(Route route, Processor processor, ErrorHandlerBuilder builder) {
        JtaTransactionErrorHandler answer;
        try {
            answer = (JtaTransactionErrorHandler)ErrorHandlerReifier.reifier((Route)route, (ErrorHandlerFactory)builder).createErrorHandler(processor);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static interface Runnable {
        public void run() throws Throwable;
    }
}

