/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.util.function.Function;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.SyntheticBean;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.core.xml.CamelServiceExporterDefinition;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

final class XmlServiceExporterBean<T>
extends SyntheticBean<T> {
    private final BeanManager manager;
    private final Bean<?> context;
    private final CamelServiceExporterDefinition exporter;
    private final Class<?> type;

    XmlServiceExporterBean(BeanManager manager, SyntheticAnnotated annotated, Class<?> type, Function<Bean<T>, String> toString, Bean<?> context, CamelServiceExporterDefinition exporter) {
        super(manager, annotated, type, null, toString);
        this.manager = manager;
        this.context = context;
        this.exporter = exporter;
        this.type = type;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        try {
            CamelContext context = ObjectHelper.isNotEmpty((Object)this.exporter.getCamelContextId()) ? BeanManagerHelper.getReferenceByName(this.manager, this.exporter.getCamelContextId(), CamelContext.class).get() : BeanManagerHelper.getReference(this.manager, CamelContext.class, this.context);
            Bean bean = this.manager.resolve(this.manager.getBeans(this.exporter.getServiceRef()));
            if (bean == null) {
                throw new UnsatisfiedResolutionException("No bean with name [" + this.exporter.getServiceRef() + "] is deployed!");
            }
            Object service = this.manager.getReference(bean, this.type, this.manager.createCreationalContext((Contextual)bean));
            Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)context, (String)this.exporter.getUri());
            try {
                ServiceHelper.initService((Object)endpoint);
                Consumer consumer = endpoint.createConsumer((Processor)new BeanProcessor(service, context));
                context.addService((Object)consumer, true, false);
            }
            catch (Exception cause) {
                throw new FailedToCreateConsumerException(endpoint, (Throwable)cause);
            }
            return (T)service;
        }
        catch (Exception cause) {
            throw new CreationException("Error while creating instance for " + this, (Throwable)cause);
        }
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }
}

