/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.transaction;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.cdi.transaction.JtaTransactionErrorHandler;
import org.apache.camel.cdi.transaction.JtaTransactionPolicy;
import org.apache.camel.cdi.transaction.TransactedDefinition;
import org.apache.camel.cdi.transaction.TransactionErrorHandler;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionErrorHandlerBuilder
extends DefaultErrorHandlerBuilder {
    public static final String ROLLBACK_LOGGING_LEVEL_PROPERTY = JtaTransactionErrorHandlerBuilder.class.getName() + "#rollbackLoggingLevel";
    private static final Logger LOG = LoggerFactory.getLogger(JtaTransactionErrorHandlerBuilder.class);
    private static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    private LoggingLevel rollbackLoggingLevel = LoggingLevel.WARN;
    private JtaTransactionPolicy transactionPolicy;
    private String policyRef;

    public boolean supportTransacted() {
        return true;
    }

    public ErrorHandlerBuilder cloneBuilder() {
        JtaTransactionErrorHandlerBuilder answer = new JtaTransactionErrorHandlerBuilder();
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(DefaultErrorHandlerBuilder other) {
        super.cloneBuilder(other);
        if (other instanceof JtaTransactionErrorHandlerBuilder) {
            JtaTransactionErrorHandlerBuilder otherTx = (JtaTransactionErrorHandlerBuilder)other;
            this.transactionPolicy = otherTx.transactionPolicy;
            this.rollbackLoggingLevel = otherTx.rollbackLoggingLevel;
        }
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        Policy policy;
        if (this.transactionPolicy == null && this.policyRef != null) {
            TransactedDefinition transactedDefinition = new TransactedDefinition();
            transactedDefinition.setRef(this.policyRef);
            policy = transactedDefinition.resolvePolicy(routeContext);
            if (policy != null) {
                if (!(policy instanceof JtaTransactionPolicy)) {
                    throw new RuntimeCamelException("The configured policy '" + this.policyRef + "' is of type '" + this.policyRef.getClass().getName() + "' but an instance of '" + JtaTransactionPolicy.class.getName() + "' is required!");
                }
                this.transactionPolicy = (JtaTransactionPolicy)policy;
            }
        }
        if (this.transactionPolicy == null) {
            LOG.debug("No transaction policy configured on TransactionErrorHandlerBuilder. Will try find it in the registry.");
            Map mapPolicy = routeContext.lookupByType(TransactedPolicy.class);
            if (mapPolicy != null && mapPolicy.size() == 1 && (policy = (TransactedPolicy)mapPolicy.values().iterator().next()) != null && policy instanceof JtaTransactionPolicy) {
                this.transactionPolicy = (JtaTransactionPolicy)policy;
            }
            if (this.transactionPolicy == null && (policy = (TransactedPolicy)routeContext.lookup(PROPAGATION_REQUIRED, TransactedPolicy.class)) != null && policy instanceof JtaTransactionPolicy) {
                this.transactionPolicy = (JtaTransactionPolicy)policy;
            }
            if (this.transactionPolicy != null) {
                LOG.debug("Found TransactionPolicy in registry to use: {}", (Object)this.transactionPolicy);
            }
        }
        ObjectHelper.notNull((Object)this.transactionPolicy, (String)"transactionPolicy", (Object)((Object)this));
        CamelContext camelContext = routeContext.getCamelContext();
        Map properties = camelContext.getProperties();
        if (properties != null && properties.containsKey(ROLLBACK_LOGGING_LEVEL_PROPERTY)) {
            this.rollbackLoggingLevel = LoggingLevel.valueOf((String)((String)properties.get(ROLLBACK_LOGGING_LEVEL_PROPERTY)));
        }
        JtaTransactionErrorHandler answer = new JtaTransactionErrorHandler(camelContext, processor, this.getLogger(), this.getOnRedelivery(), this.getRedeliveryPolicy(), this.getExceptionPolicyStrategy(), this.transactionPolicy, this.getRetryWhilePolicy(camelContext), this.getExecutorService(camelContext), this.rollbackLoggingLevel, this.getOnExceptionOccurred());
        this.configure(routeContext, (ErrorHandler)answer);
        return answer;
    }

    public JtaTransactionErrorHandlerBuilder setTransactionPolicy(String ref) {
        this.policyRef = ref;
        return this;
    }

    public JtaTransactionErrorHandlerBuilder setTransactionPolicy(JtaTransactionPolicy transactionPolicy) {
        this.transactionPolicy = transactionPolicy;
        return this;
    }

    public JtaTransactionErrorHandlerBuilder setRollbackLoggingLevel(LoggingLevel rollbackLoggingLevel) {
        this.rollbackLoggingLevel = rollbackLoggingLevel;
        return this;
    }

    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(TransactionErrorHandler.class), LoggingLevel.ERROR);
    }

    public String toString() {
        return "JtaTransactionErrorHandlerBuilder";
    }
}

