/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;

class AnnotatedDelegate
implements Annotated {
    private final Annotated delegate;
    private final Set<Annotation> annotations;

    AnnotatedDelegate(Annotated delegate, Set<Annotation> annotations) {
        this.delegate = delegate;
        this.annotations = new HashSet<Annotation>(annotations);
    }

    AnnotatedDelegate(Annotated delegate) {
        this.delegate = delegate;
        this.annotations = delegate.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getBaseType() {
        return this.delegate.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.delegate.getTypeClosure();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }
}

