/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.maven.DefaultMavenArtifactProvider;
import org.apache.camel.catalog.maven.MavenArtifactProvider;

@Api(value="/camel-catalog", description="Camel Catalog REST API")
@Path(value="/camel-catalog")
public class CamelCatalogRest {
    private CamelCatalog catalog = new DefaultCamelCatalog(true);
    private MavenArtifactProvider maven = new DefaultMavenArtifactProvider();

    public CamelCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(CamelCatalog catalog) {
        this.catalog = catalog;
    }

    @GET
    @Path(value="/catalogVersion")
    @Produces(value={"text/plain"})
    @ApiOperation(value="The version of this Camel Catalog")
    public String getCatalogVersion() {
        return this.catalog.getCatalogVersion();
    }

    @GET
    @Path(value="/findComponentNames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the component names from the Camel catalog")
    public List<String> findComponentNames() {
        return this.catalog.findComponentNames();
    }

    @GET
    @Path(value="/findDataFormatNames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the data format names from the Camel catalog")
    public List<String> findDataFormatNames() {
        return this.catalog.findDataFormatNames();
    }

    @GET
    @Path(value="/findLanguageNames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the language names from the Camel catalog")
    public List<String> findLanguageNames() {
        return this.catalog.findLanguageNames();
    }

    @GET
    @Path(value="/findModelNames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the model (EIP) names from the Camel catalog")
    public List<String> findModelNames() {
        return this.catalog.findModelNames();
    }

    @GET
    @Path(value="/findComponentNames/{filter}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the component names from the Camel catalog that matches the label")
    public List<String> findComponentNames(@ApiParam(value="Filter used to only return component names that matches by their labels") @PathParam(value="filter") String filter) {
        return this.catalog.findComponentNames(filter);
    }

    @GET
    @Path(value="/findDataFormatNames/{filter}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the data format names from the Camel catalog that matches the label")
    public List<String> findDataFormatNames(@ApiParam(value="Filter used to only return data format names that matches by their labels") @PathParam(value="filter") String filter) {
        return this.catalog.findDataFormatNames(filter);
    }

    @GET
    @Path(value="/findLanguageNames/{filter}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the language names from the Camel catalog that matches the label")
    public List<String> findLanguageNames(@ApiParam(value="Filter used to only return language names that matches by their labels") @PathParam(value="filter") String filter) {
        return this.catalog.findLanguageNames(filter);
    }

    @GET
    @Path(value="/findModelNames/{filter}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the model (EIP) names from the Camel catalog that matches the label")
    public List<String> findModelNames(@ApiParam(value="Filter used to only return model (EIP) names that matches by their labels") @PathParam(value="filter") String filter) {
        return this.catalog.findModelNames(filter);
    }

    @GET
    @Path(value="/componentJSonSchema/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the component information as JSon format")
    public String componentJSonSchema(@ApiParam(value="The name of the component", required=true) @PathParam(value="name") String name) {
        return this.catalog.componentJSonSchema(name);
    }

    @GET
    @Path(value="/dataFormatJSonSchema/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the data format information as JSon format")
    public String dataFormatJSonSchema(@ApiParam(value="The name of the data format", required=true) @PathParam(value="name") String name) {
        return this.catalog.dataFormatJSonSchema(name);
    }

    @GET
    @Path(value="/languageJSonSchema/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the language information as JSon format")
    public String languageJSonSchema(@ApiParam(value="The name of the language", required=true) @PathParam(value="name") String name) {
        return this.catalog.languageJSonSchema(name);
    }

    @GET
    @Path(value="/modelJSonSchema/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the model (EIP) information as JSon format")
    public String modelJSonSchema(@ApiParam(value="The name of the model (EIP)", required=true) @PathParam(value="name") String name) {
        return this.catalog.modelJSonSchema(name);
    }

    @GET
    @Path(value="/componentAsciiDoc/{name}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the component documentation as Ascii doc format")
    public String componentAsciiDoc(@ApiParam(value="The name of the component", required=true) @PathParam(value="name") String name) {
        return this.catalog.componentAsciiDoc(name);
    }

    @GET
    @Path(value="/dataFormatAsciiDoc/{name}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the data format documentation as Ascii doc format")
    public String dataFormatAsciiDoc(@ApiParam(value="The name of the data format", required=true) @PathParam(value="name") String name) {
        return this.catalog.dataFormatAsciiDoc(name);
    }

    @GET
    @Path(value="/languageAsciiDoc/{name}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the language documentation as Ascii doc format")
    public String languageAsciiDoc(@ApiParam(value="The name of the language", required=true) @PathParam(value="name") String name) {
        return this.catalog.languageAsciiDoc(name);
    }

    @GET
    @Path(value="/findComponentLabels")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the unique label names all the components are using")
    public Set<String> findComponentLabels() {
        return this.catalog.findComponentLabels();
    }

    @GET
    @Path(value="/findDataFormatLabels")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the unique label names all the data formats are using")
    public Set<String> findDataFormatLabels() {
        return this.catalog.findDataFormatLabels();
    }

    @GET
    @Path(value="/findLanguageLabels")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the unique label names all the languages are using")
    public Set<String> findLanguageLabels() {
        return this.catalog.findLanguageLabels();
    }

    @GET
    @Path(value="/findModelLabels")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the unique label names all the models (EIP) are using.")
    public Set<String> findModelLabels() {
        return this.catalog.findModelLabels();
    }

    @GET
    @Path(value="/archetypeCatalogAsXml")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Returns the Apache Camel Maven Archetype catalog in XML format")
    public String archetypeCatalogAsXml() {
        return this.catalog.archetypeCatalogAsXml();
    }

    @GET
    @Path(value="/springSchemaAsXml")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Returns the Camel Spring XML schema")
    public String springSchemaAsXml() {
        return this.catalog.springSchemaAsXml();
    }

    @GET
    @Path(value="/blueprintSchemaAsXml")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Returns the Camel Blueprint XML schema")
    public String blueprintSchemaAsXml() {
        return this.catalog.blueprintSchemaAsXml();
    }

    @GET
    @Path(value="/listComponentsAsJson")
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists all the components summary details in JSon")
    public String listComponentsAsJson() {
        return this.catalog.listComponentsAsJson();
    }

    @GET
    @Path(value="/listDataFormatsAsJson")
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists all the data formats summary details in JSon")
    public String listDataFormatsAsJson() {
        return this.catalog.listDataFormatsAsJson();
    }

    @GET
    @Path(value="/listLanguagesAsJson")
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists all the languages summary details in JSon")
    public String listLanguagesAsJson() {
        return this.catalog.listLanguagesAsJson();
    }

    @GET
    @Path(value="/listModelsAsJson")
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists all the models (EIP) summary details in JSon")
    public String listModelsAsJson() {
        return this.catalog.listModelsAsJson();
    }

    @GET
    @Path(value="/summaryAsJson")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reports a summary what the catalog contains in JSon")
    public String summaryAsJson() {
        return this.catalog.summaryAsJson();
    }

    @POST
    @Path(value="/asEndpointUri/{scheme}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates an endpoint uri in Java style configured using the provided options in the JSon body")
    public String asEndpointUri(@ApiParam(value="The component scheme", readOnly=true) @PathParam(value="scheme") String scheme, @ApiParam(value="The options as a JSon map with key/value pairs", required=true) String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(json, Map.class);
            return this.catalog.asEndpointUri(scheme, map, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @POST
    @Path(value="/asEndpointUriXml/{scheme}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates an endpoint uri in XML style configured using the provided options in the JSon body")
    public String asEndpointUriXml(@ApiParam(value="The component scheme", readOnly=true) @PathParam(value="scheme") String scheme, @ApiParam(value="The options as a JSon map with key/value pairs", required=true) String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(json, Map.class);
            return this.catalog.asEndpointUriXml(scheme, map, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @POST
    @Path(value="/mavenCacheDirectory/{name}")
    @ApiOperation(value="Configures the Maven cache directory to use when downloading artifacts")
    public void mavenCacheDirectory(@ApiParam(value="The name of the cache directory", required=true) @PathParam(value="name") String name) {
        this.maven.setCacheDirectory(name);
    }

    @POST
    @Path(value="/addMavenRepository/{name}/{url}")
    @ApiOperation(value="Adds a third party Maven repository to use for downloading Maven artifacts")
    public void addMavenRepository(@ApiParam(value="The name of the Maven repository", required=true) @PathParam(value="name") String name, @ApiParam(value="The URL of the Maven repository", required=true) @PathParam(value="url") String url) {
        this.maven.addMavenRepository(name, url);
    }

    @POST
    @Path(value="/addComponentFromMavenArtifact/{groupId}/{artifactId}/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Downloads the Maven artifact and scan for custom Camel components which will be added to the catalog and returns the names of the found components")
    public Set<String> addComponentFromMavenArtifact(@ApiParam(value="The Maven groupId", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="The Maven artifactId", required=true) @PathParam(value="artifactId") String artifactId, @ApiParam(value="The Maven version", required=true) @PathParam(value="version") String version) {
        return this.maven.addArtifactToCatalog(this.catalog, null, groupId, artifactId, version);
    }
}

