/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.catalog.impl.CatalogHelper;
import org.slf4j.Logger;

public final class ComponentArtifactHelper {
    private ComponentArtifactHelper() {
    }

    public static Properties loadComponentProperties(ClassLoader classLoader, Logger logger) {
        Properties answer = new Properties();
        try {
            InputStream is = classLoader.getResourceAsStream("META-INF/services/org/apache/camel/component.properties");
            if (is != null) {
                answer.load(is);
            }
        }
        catch (Exception e) {
            logger.warn("Error loading META-INF/services/org/apache/camel/component.properties file due {}", (Object)e.getMessage(), (Object)e);
        }
        return answer;
    }

    public static String extractComponentJavaType(ClassLoader classLoader, String scheme, Logger logger) {
        try {
            InputStream is = classLoader.getResourceAsStream("META-INF/services/org/apache/camel/component/" + scheme);
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                return (String)props.get("class");
            }
        }
        catch (Exception e) {
            logger.warn("Error loading META-INF/services/org/apache/camel/component/{} file due {}", new Object[]{scheme, e.getMessage(), e});
        }
        return null;
    }

    public static String loadComponentJSonSchema(ClassLoader classLoader, String scheme, Logger logger) {
        String answer = null;
        Object path = null;
        String javaType = ComponentArtifactHelper.extractComponentJavaType(classLoader, scheme, logger);
        if (javaType != null) {
            int pos = javaType.lastIndexOf(46);
            path = javaType.substring(0, pos);
            path = ((String)path).replace('.', '/');
            path = (String)path + "/" + scheme + ".json";
        }
        if (path != null) {
            try {
                InputStream is = classLoader.getResourceAsStream((String)path);
                if (is != null) {
                    answer = CatalogHelper.loadText((InputStream)is);
                }
            }
            catch (Exception e) {
                logger.warn("Error loading {} file due {}", new Object[]{path, e.getMessage(), e});
            }
        }
        return answer;
    }
}

