/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.maven.OpenURLClassLoader;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloader;
import org.apache.camel.tooling.maven.MavenDownloaderImpl;
import org.apache.camel.tooling.maven.MavenResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenVersionManager
implements VersionManager,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenVersionManager.class);
    private ClassLoader classLoader;
    private final OpenURLClassLoader helperClassLoader = new OpenURLClassLoader();
    private String version;
    private String runtimeProviderVersion;
    private String localRepository;
    private boolean log;
    private final MavenDownloader downloader;
    private final Map<String, String> repositories = new LinkedHashMap<String, String>();
    private int connectTimeout = 10000;
    private int requestTimeout = 1800000;
    private boolean customized;

    public MavenVersionManager() {
        this.downloader = new MavenDownloaderImpl();
        ((MavenDownloaderImpl)this.downloader).build();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setCacheDirectory(String directory) {
        this.localRepository = directory;
        this.customized = true;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public void setHttpClientTimeout(int timeout) {
        this.connectTimeout = timeout;
        this.customized = true;
    }

    public void setHttpClientRequestTimeout(int timeout) {
        this.requestTimeout = timeout;
        this.customized = true;
    }

    public void addMavenRepository(String name, String url) {
        this.repositories.put(name, url);
    }

    public String getLoadedVersion() {
        return this.version;
    }

    public boolean loadVersion(String version) {
        try {
            MavenDownloader mavenDownloader = this.downloader;
            if (this.customized) {
                mavenDownloader = mavenDownloader.customize(this.localRepository, this.connectTimeout, this.requestTimeout);
            }
            String camelCatalogGAV = String.format("org.apache.camel:camel-catalog:%s", version);
            this.resolve(mavenDownloader, camelCatalogGAV, version.contains("SNAPSHOT"));
            this.version = version;
            return true;
        }
        catch (Exception e) {
            if (this.log) {
                LOGGER.warn("Cannot load version {} due {}", new Object[]{version, e.getMessage(), e});
            }
            return false;
        }
    }

    public String getRuntimeProviderLoadedVersion() {
        return this.runtimeProviderVersion;
    }

    public boolean loadRuntimeProviderVersion(String groupId, String artifactId, String version) {
        try {
            MavenDownloader mavenDownloader = this.downloader;
            if (this.customized) {
                mavenDownloader = mavenDownloader.customize(this.localRepository, this.connectTimeout, this.requestTimeout);
            }
            String gav = String.format("%s:%s:%s", groupId, artifactId, version);
            this.resolve(mavenDownloader, gav, version.contains("SNAPSHOT"));
            this.runtimeProviderVersion = version;
            return true;
        }
        catch (Exception e) {
            if (this.log) {
                LOGGER.warn("Cannot load runtime provider version {} due {}", new Object[]{version, e.getMessage(), e});
            }
            return false;
        }
    }

    private void resolve(MavenDownloader mavenDownloader, String gav, boolean useSnapshots) throws MavenResolutionException, MalformedURLException {
        LinkedHashSet<String> extraRepositories = new LinkedHashSet<String>(this.repositories.values());
        List artifacts = mavenDownloader.resolveArtifacts(Collections.singletonList(gav), extraRepositories, false, useSnapshots);
        for (MavenArtifact ma : artifacts) {
            this.helperClassLoader.addURL(ma.getFile().toURI().toURL());
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (this.runtimeProviderVersion != null) {
            is = this.doGetResourceAsStream(name, this.runtimeProviderVersion);
        }
        if (is == null && this.version != null) {
            is = this.doGetResourceAsStream(name, this.version);
        }
        if (this.classLoader != null && is == null) {
            is = this.classLoader.getResourceAsStream(name);
        }
        if (is == null) {
            is = MavenVersionManager.class.getClassLoader().getResourceAsStream(name);
        }
        if (is == null) {
            is = this.helperClassLoader.getResourceAsStream(name);
        }
        return is;
    }

    private InputStream doGetResourceAsStream(String name, String version) {
        block5: {
            if (version == null) {
                return null;
            }
            try {
                URL found = null;
                Enumeration<URL> urls = this.helperClassLoader.getResources(name);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (!url.getPath().contains(version)) continue;
                    found = url;
                    break;
                }
                if (found != null) {
                    return found.openStream();
                }
            }
            catch (IOException e) {
                if (!this.log) break block5;
                LOGGER.warn("Cannot open resource {} and version {} due {}", new Object[]{name, version, e.getMessage(), e});
            }
        }
        return null;
    }

    @Override
    public void close() {
    }
}

