/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.maven.ComponentArtifactHelper;
import org.apache.camel.catalog.maven.MavenArtifactProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMavenArtifactProvider
implements MavenArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMavenArtifactProvider.class);
    private String cacheDirectory;
    private boolean log;

    public void setLog(boolean log) {
        this.log = log;
    }

    @Override
    public void setCacheDirectory(String directory) {
        this.cacheDirectory = directory;
    }

    @Override
    public void addMavenRepository(String name, String url) {
        HashMap<String, String> repo = new HashMap<String, String>();
        repo.put("name", name);
        repo.put("root", url);
        Grape.addResolver(repo);
    }

    @Override
    public Set<String> addArtifactToCatalog(CamelCatalog camelCatalog, String groupId, String artifactId, String version) {
        LinkedHashSet<String> names;
        block11: {
            names = new LinkedHashSet<String>();
            try {
                if (this.cacheDirectory != null) {
                    if (this.log) {
                        LOGGER.debug("Using cache directory: {}", (Object)this.cacheDirectory);
                    }
                    System.setProperty("grape.root", this.cacheDirectory);
                }
                Grape.setEnableAutoDownload((boolean)true);
                try (GroovyClassLoader classLoader = new GroovyClassLoader();){
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("classLoader", classLoader);
                    param.put("group", groupId);
                    param.put("module", artifactId);
                    param.put("version", version);
                    param.put("validate", false);
                    param.put("transitive", false);
                    if (this.log) {
                        LOGGER.info("Downloading {}:{}:{}", new Object[]{groupId, artifactId, version});
                    }
                    Grape.grab(param);
                    if (camelCatalog != null) {
                        this.scanCamelComponents(camelCatalog, (ClassLoader)classLoader, names);
                    }
                }
            }
            catch (Exception e) {
                if (!this.log) break block11;
                LOGGER.warn("Error during add components from artifact {}:{}:{} due {}", new Object[]{groupId, artifactId, version, e.getMessage(), e});
            }
        }
        return names;
    }

    protected void scanCamelComponents(CamelCatalog camelCatalog, ClassLoader classLoader, Set<String> names) {
        Properties properties = ComponentArtifactHelper.loadComponentProperties(this.log, classLoader);
        String components = (String)properties.get("components");
        if (components != null) {
            String[] part;
            for (String scheme : part = components.split("\\s")) {
                if (camelCatalog.findComponentNames().contains(scheme)) continue;
                this.findClassName(camelCatalog, classLoader, names, scheme);
            }
        }
    }

    private void findClassName(CamelCatalog camelCatalog, ClassLoader classLoader, Set<String> names, String scheme) {
        String json;
        String javaType = ComponentArtifactHelper.extractComponentJavaType(this.log, classLoader, scheme);
        if (javaType != null && (json = ComponentArtifactHelper.loadComponentJSonSchema(this.log, classLoader, scheme)) != null) {
            if (this.log) {
                LOGGER.info("Adding component: {}", (Object)scheme);
            }
            camelCatalog.addComponent(scheme, javaType, json);
            names.add(scheme);
        }
    }
}

