/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.maven.ComponentArtifactHelper;
import org.apache.camel.catalog.maven.MavenArtifactProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMavenArtifactProvider
implements MavenArtifactProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMavenArtifactProvider.class);
    private String cacheDirectory;
    private boolean log;

    public void setLog(boolean log) {
        this.log = log;
    }

    @Override
    public void setCacheDirectory(String directory) {
        this.cacheDirectory = directory;
    }

    @Override
    public void addMavenRepository(String name, String url) {
        HashMap<String, String> repo = new HashMap<String, String>();
        repo.put("name", name);
        repo.put("root", url);
        Grape.addResolver(repo);
    }

    @Override
    public Set<String> addArtifactToCatalog(CamelCatalog camelCatalog, String groupId, String artifactId, String version) {
        LinkedHashSet<String> names;
        block18: {
            names = new LinkedHashSet<String>();
            try {
                if (this.cacheDirectory != null) {
                    if (this.log) {
                        LOG.debug("Using cache directory: {}", (Object)this.cacheDirectory);
                    }
                    System.setProperty("grape.root", this.cacheDirectory);
                }
                Grape.setEnableAutoDownload((boolean)true);
                try (GroovyClassLoader classLoader = new GroovyClassLoader();){
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("classLoader", classLoader);
                    param.put("group", groupId);
                    param.put("module", artifactId);
                    param.put("version", version);
                    param.put("validate", false);
                    param.put("transitive", false);
                    if (this.log) {
                        LOG.info("Downloading {}:{}:{}", new Object[]{groupId, artifactId, version});
                    }
                    Grape.grab(param);
                    if (camelCatalog != null) {
                        this.scanCamelComponents(camelCatalog, (ClassLoader)classLoader, names);
                    }
                }
            }
            catch (Exception e) {
                if (!this.log) break block18;
                LOG.warn("Error during add components from artifact {}:{}:{} due {}", new Object[]{groupId, artifactId, version, e.getMessage(), e});
            }
        }
        return names;
    }

    protected void scanCamelComponents(CamelCatalog camelCatalog, ClassLoader classLoader, Set<String> names) {
        String components;
        Properties properties = ComponentArtifactHelper.loadComponentProperties(this.log, classLoader);
        if (properties != null && (components = (String)properties.get("components")) != null) {
            String[] part;
            for (String scheme : part = components.split("\\s")) {
                String json;
                String javaType;
                if (camelCatalog.findComponentNames().contains(scheme) || (javaType = ComponentArtifactHelper.extractComponentJavaType(this.log, classLoader, scheme)) == null || (json = ComponentArtifactHelper.loadComponentJSonSchema(this.log, classLoader, scheme)) == null) continue;
                if (this.log) {
                    LOG.info("Adding component: {}", (Object)scheme);
                }
                camelCatalog.addComponent(scheme, javaType, json);
                names.add(scheme);
            }
        }
    }
}

