/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.catalog.impl.CatalogHelper;

public final class ComponentArtifactHelper {
    private ComponentArtifactHelper() {
    }

    public static Properties loadComponentProperties(boolean log, ClassLoader classLoader) {
        Properties answer;
        block3: {
            answer = new Properties();
            try {
                InputStream is = classLoader.getResourceAsStream("META-INF/services/org/apache/camel/component.properties");
                if (is != null) {
                    answer.load(is);
                }
            }
            catch (Throwable e) {
                if (!log) break block3;
                System.out.println("WARN: Error loading META-INF/services/org/apache/camel/component.properties file due " + e.getMessage());
            }
        }
        return answer;
    }

    public static String extractComponentJavaType(boolean log, ClassLoader classLoader, String scheme) {
        block3: {
            try {
                InputStream is = classLoader.getResourceAsStream("META-INF/services/org/apache/camel/component/" + scheme);
                if (is != null) {
                    Properties props = new Properties();
                    props.load(is);
                    return (String)props.get("class");
                }
            }
            catch (Throwable e) {
                if (!log) break block3;
                System.out.println("WARN: Error loading META-INF/services/org/apache/camel/component/" + scheme + " file due " + e.getMessage());
            }
        }
        return null;
    }

    public static String loadComponentJSonSchema(boolean log, ClassLoader classLoader, String scheme) {
        String answer;
        block5: {
            answer = null;
            String path = null;
            String javaType = ComponentArtifactHelper.extractComponentJavaType(log, classLoader, scheme);
            if (javaType != null) {
                int pos = javaType.lastIndexOf(46);
                path = javaType.substring(0, pos);
                path = path.replace('.', '/');
                path = path + "/" + scheme + ".json";
            }
            if (path != null) {
                try {
                    InputStream is = classLoader.getResourceAsStream(path);
                    if (is != null) {
                        answer = CatalogHelper.loadText((InputStream)is);
                    }
                }
                catch (Throwable e) {
                    if (!log) break block5;
                    System.out.println("WARN: Error loading " + path + " file due " + e.getMessage());
                }
            }
        }
        return answer;
    }
}

