/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import java.io.InputStream;
import org.apache.camel.catalog.CatalogHelper;

public final class ConnectorArtifactHelper {
    private ConnectorArtifactHelper() {
    }

    public static String[] loadJSonSchemas(boolean log, ClassLoader classLoader) {
        String[] answer = new String[]{ConnectorArtifactHelper.loadJsonSchema(log, classLoader, "camel-connector.json"), ConnectorArtifactHelper.loadJsonSchema(log, classLoader, "camel-connector-schema.json"), ConnectorArtifactHelper.loadJsonSchema(log, classLoader, "camel-component-schema.json")};
        return answer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadJsonSchema(boolean log, ClassLoader classLoader, String jsonSchemaPath) {
        try (InputStream is = classLoader.getResourceAsStream(jsonSchemaPath);){
            if (is == null) return null;
            String string = CatalogHelper.loadText((InputStream)is);
            return string;
        }
        catch (Throwable e) {
            if (!log) return null;
            System.out.println("WARN: Error loading " + jsonSchemaPath + " file due " + e.getMessage());
        }
        return null;
    }
}

