/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CollectionStringBuffer;
import org.apache.camel.catalog.connector.CamelConnectorCatalog;
import org.apache.camel.catalog.maven.ComponentArtifactHelper;
import org.apache.camel.catalog.maven.ConnectorArtifactHelper;
import org.apache.camel.catalog.maven.MavenArtifactProvider;

public class DefaultMavenArtifactProvider
implements MavenArtifactProvider {
    private String cacheDirectory;
    private boolean log;

    public void setLog(boolean log) {
        this.log = log;
    }

    @Override
    public void setCacheDirectory(String directory) {
        this.cacheDirectory = directory;
    }

    @Override
    public void addMavenRepository(String name, String url) {
        HashMap<String, String> repo = new HashMap<String, String>();
        repo.put("name", name);
        repo.put("root", url);
        Grape.addResolver(repo);
    }

    @Override
    public Set<String> addArtifactToCatalog(CamelCatalog camelCatalog, CamelConnectorCatalog camelConnectorCatalog, String groupId, String artifactId, String version) {
        LinkedHashSet<String> names;
        block19: {
            names = new LinkedHashSet<String>();
            try {
                if (this.cacheDirectory != null) {
                    if (this.log) {
                        System.out.println("DEBUG: Using cache directory: " + this.cacheDirectory);
                    }
                    System.setProperty("grape.root", this.cacheDirectory);
                }
                Grape.setEnableAutoDownload((boolean)true);
                try (GroovyClassLoader classLoader = new GroovyClassLoader();){
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("classLoader", classLoader);
                    param.put("group", groupId);
                    param.put("module", artifactId);
                    param.put("version", version);
                    param.put("validate", false);
                    param.put("transitive", false);
                    if (this.log) {
                        System.out.println("Downloading " + groupId + ":" + artifactId + ":" + version);
                    }
                    Grape.grab(param);
                    if (camelCatalog != null) {
                        this.scanCamelComponents(camelCatalog, (ClassLoader)classLoader, names);
                    }
                    if (camelConnectorCatalog != null) {
                        this.scanCamelConnectors(camelConnectorCatalog, (ClassLoader)classLoader, groupId, artifactId, version, names);
                    }
                }
            }
            catch (Exception e) {
                if (!this.log) break block19;
                System.out.println("WARN: Error during add components from artifact " + groupId + ":" + artifactId + ":" + version + " due " + e.getMessage());
            }
        }
        return names;
    }

    protected void scanCamelComponents(CamelCatalog camelCatalog, ClassLoader classLoader, Set<String> names) {
        String components;
        Properties properties = ComponentArtifactHelper.loadComponentProperties(this.log, classLoader);
        if (properties != null && (components = (String)properties.get("components")) != null) {
            String[] part;
            for (String scheme : part = components.split("\\s")) {
                String json;
                String javaType;
                if (camelCatalog.findComponentNames().contains(scheme) || (javaType = ComponentArtifactHelper.extractComponentJavaType(this.log, classLoader, scheme)) == null || (json = ComponentArtifactHelper.loadComponentJSonSchema(this.log, classLoader, scheme)) == null) continue;
                if (this.log) {
                    System.out.println("Adding component: " + scheme);
                }
                camelCatalog.addComponent(scheme, javaType, json);
                names.add(scheme);
            }
        }
    }

    protected void scanCamelConnectors(CamelConnectorCatalog camelConnectorCatalog, ClassLoader classLoader, String groupId, String artifactId, String version, Set<String> names) {
        block5: {
            String[] json = ConnectorArtifactHelper.loadJSonSchemas(this.log, classLoader);
            if (json != null && !camelConnectorCatalog.hasConnector(groupId, artifactId, version)) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode tree = mapper.readTree(json[0]);
                    String name = tree.get("name").textValue();
                    String scheme = tree.get("scheme").textValue();
                    String javaType = tree.get("javaType").textValue();
                    String description = tree.get("description").textValue();
                    Iterator it = tree.withArray("labels").iterator();
                    CollectionStringBuffer csb = new CollectionStringBuffer(",");
                    while (it.hasNext()) {
                        String text = ((JsonNode)it.next()).textValue();
                        csb.append((Object)text);
                    }
                    if (this.log) {
                        System.out.println("Adding connector: " + name + " with scheme: " + scheme);
                    }
                    camelConnectorCatalog.addConnector(groupId, artifactId, version, name, scheme, javaType, description, csb.toString(), json[0], json[1], json[2]);
                    names.add(name);
                }
                catch (Throwable e) {
                    if (!this.log) break block5;
                    System.out.println("WARN: Error parsing Connector JSon due " + e.getMessage());
                }
            }
        }
    }
}

