/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.camel.catalog.VersionManager;

public class MavenVersionManager
implements VersionManager {
    private final ClassLoader classLoader = new GroovyClassLoader();
    private String version;

    public void addMavenRepository(String name, String url) {
        HashMap<String, String> repo = new HashMap<String, String>();
        repo.put("name", name);
        repo.put("root", url);
        Grape.addResolver(repo);
    }

    public String getLoadedVersion() {
        return this.version;
    }

    public boolean loadVersion(String version) {
        try {
            Grape.setEnableAutoDownload((boolean)true);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("classLoader", this.classLoader);
            param.put("group", "org.apache.camel");
            param.put("module", "camel-catalog");
            param.put("version", version);
            Grape.grab(param);
            this.version = version;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public InputStream getResourceAsStream(String name) {
        if (this.version == null) {
            return null;
        }
        try {
            URL found = null;
            Enumeration<URL> urls = this.classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (!url.getPath().contains(this.version)) continue;
                found = url;
                break;
            }
            if (found != null) {
                return found.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

