/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.EvictionType;
import org.apache.camel.component.caffeine.cache.CaffeineCacheComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class CaffeineCacheComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private CaffeineConfiguration getOrCreateConfiguration(CaffeineCacheComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new CaffeineConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CaffeineCacheComponent target = (CaffeineCacheComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "action": {
                this.getOrCreateConfiguration(target).setAction((String)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cacheloader": 
            case "cacheLoader": {
                this.getOrCreateConfiguration(target).setCacheLoader((CacheLoader)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, CacheLoader.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((CaffeineConfiguration)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, CaffeineConfiguration.class, (Object)value));
                return true;
            }
            case "createcacheifnotexist": 
            case "createCacheIfNotExist": {
                this.getOrCreateConfiguration(target).setCreateCacheIfNotExist((Boolean)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "evictiontype": 
            case "evictionType": {
                this.getOrCreateConfiguration(target).setEvictionType((EvictionType)((Object)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, EvictionType.class, (Object)value)));
                return true;
            }
            case "expireafteraccesstime": 
            case "expireAfterAccessTime": {
                this.getOrCreateConfiguration(target).setExpireAfterAccessTime((Integer)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "expireafterwritetime": 
            case "expireAfterWriteTime": {
                this.getOrCreateConfiguration(target).setExpireAfterWriteTime((Integer)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "initialcapacity": 
            case "initialCapacity": {
                this.getOrCreateConfiguration(target).setInitialCapacity((Integer)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "key": {
                this.getOrCreateConfiguration(target).setKey(CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "keytype": 
            case "keyType": {
                this.getOrCreateConfiguration(target).setKeyType((String)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maximumsize": 
            case "maximumSize": {
                this.getOrCreateConfiguration(target).setMaximumSize((Integer)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "removallistener": 
            case "removalListener": {
                this.getOrCreateConfiguration(target).setRemovalListener((RemovalListener)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, RemovalListener.class, (Object)value));
                return true;
            }
            case "statscounter": 
            case "statsCounter": {
                this.getOrCreateConfiguration(target).setStatsCounter((StatsCounter)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, StatsCounter.class, (Object)value));
                return true;
            }
            case "statsenabled": 
            case "statsEnabled": {
                this.getOrCreateConfiguration(target).setStatsEnabled((Boolean)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "valuetype": 
            case "valueType": {
                this.getOrCreateConfiguration(target).setValueType((String)CaffeineCacheComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CaffeineCacheComponent target = (CaffeineCacheComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "action": {
                return this.getOrCreateConfiguration(target).getAction();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "cacheloader": 
            case "cacheLoader": {
                return this.getOrCreateConfiguration(target).getCacheLoader();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "createcacheifnotexist": 
            case "createCacheIfNotExist": {
                return this.getOrCreateConfiguration(target).isCreateCacheIfNotExist();
            }
            case "evictiontype": 
            case "evictionType": {
                return this.getOrCreateConfiguration(target).getEvictionType();
            }
            case "expireafteraccesstime": 
            case "expireAfterAccessTime": {
                return this.getOrCreateConfiguration(target).getExpireAfterAccessTime();
            }
            case "expireafterwritetime": 
            case "expireAfterWriteTime": {
                return this.getOrCreateConfiguration(target).getExpireAfterWriteTime();
            }
            case "initialcapacity": 
            case "initialCapacity": {
                return this.getOrCreateConfiguration(target).getInitialCapacity();
            }
            case "key": {
                return this.getOrCreateConfiguration(target).getKey();
            }
            case "keytype": 
            case "keyType": {
                return this.getOrCreateConfiguration(target).getKeyType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maximumsize": 
            case "maximumSize": {
                return this.getOrCreateConfiguration(target).getMaximumSize();
            }
            case "removallistener": 
            case "removalListener": {
                return this.getOrCreateConfiguration(target).getRemovalListener();
            }
            case "statscounter": 
            case "statsCounter": {
                return this.getOrCreateConfiguration(target).getStatsCounter();
            }
            case "statsenabled": 
            case "statsEnabled": {
                return this.getOrCreateConfiguration(target).isStatsEnabled();
            }
            case "valuetype": 
            case "valueType": {
                return this.getOrCreateConfiguration(target).getValueType();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("action", String.class);
        map.put("cacheLoader", CacheLoader.class);
        map.put("createCacheIfNotExist", Boolean.TYPE);
        map.put("evictionType", EvictionType.class);
        map.put("expireAfterAccessTime", Integer.TYPE);
        map.put("expireAfterWriteTime", Integer.TYPE);
        map.put("initialCapacity", Integer.TYPE);
        map.put("key", Object.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("maximumSize", Integer.TYPE);
        map.put("removalListener", RemovalListener.class);
        map.put("statsCounter", StatsCounter.class);
        map.put("statsEnabled", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("configuration", CaffeineConfiguration.class);
        map.put("keyType", String.class);
        map.put("valueType", String.class);
        ALL_OPTIONS = map;
    }
}

