/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.load;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.CaffeineConstants;
import org.apache.camel.component.caffeine.cache.CaffeineCacheEndpoint;
import org.apache.camel.component.caffeine.load.CaffeineLoadCacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.20.0", scheme="caffeine-loadcache", title="Caffeine LoadCache", syntax="caffeine-loadcache:cacheName", category={Category.CACHE, Category.DATAGRID, Category.CLUSTERING}, producerOnly=true, headersClass=CaffeineConstants.class)
public class CaffeineLoadCacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="the cache name")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final CaffeineConfiguration configuration;
    private LoadingCache cache;

    CaffeineLoadCacheEndpoint(String uri, Component component, String cacheName, CaffeineConfiguration configuration) {
        super(uri, component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new CaffeineLoadCacheProducer(this, this.configuration, this.cache);
    }

    protected void doStart() throws Exception {
        this.cache = (LoadingCache)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)this.cacheName, LoadingCache.class);
        if (this.cache == null) {
            if (this.configuration.isCreateCacheIfNotExist()) {
                Caffeine builder = Caffeine.newBuilder();
                CaffeineCacheEndpoint.defineBuilder(builder, this.configuration);
                this.cache = builder.build(this.configuration.getCacheLoader());
            } else {
                throw new IllegalArgumentException("Loading cache instance '" + this.cacheName + "' not found and createCacheIfNotExist is set to false");
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    CaffeineConfiguration getConfiguration() {
        return this.configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new IllegalArgumentException("The caffeine-loadcache component doesn't support consumer");
    }
}

