/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.CaffeineConstants;
import org.apache.camel.component.caffeine.EvictionType;
import org.apache.camel.component.caffeine.cache.CaffeineCacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.20.0", scheme="caffeine-cache", title="Caffeine Cache", syntax="caffeine-cache:cacheName", category={Category.CACHE, Category.DATAGRID, Category.CLUSTERING}, producerOnly=true, headersClass=CaffeineConstants.class)
public class CaffeineCacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="the cache name")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final CaffeineConfiguration configuration;
    private Cache cache;

    CaffeineCacheEndpoint(String uri, Component component, String cacheName, CaffeineConfiguration configuration) {
        super(uri, component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new CaffeineCacheProducer(this, this.configuration, this.cache);
    }

    protected void doStart() throws Exception {
        this.cache = (Cache)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)this.cacheName, Cache.class);
        if (this.cache == null) {
            if (this.configuration.isCreateCacheIfNotExist()) {
                Caffeine builder = Caffeine.newBuilder();
                CaffeineCacheEndpoint.defineBuilder(builder, this.configuration);
                this.cache = builder.build();
            } else {
                throw new IllegalArgumentException("Cache instance '" + this.cacheName + "' not found and createCacheIfNotExist is set to false");
            }
        }
        super.doStart();
    }

    public static void defineBuilder(Caffeine<?, ?> builder, CaffeineConfiguration configuration) {
        if (configuration.getEvictionType() == EvictionType.SIZE_BASED) {
            builder.initialCapacity(configuration.getInitialCapacity());
            builder.maximumSize((long)configuration.getMaximumSize());
        } else if (configuration.getEvictionType() == EvictionType.TIME_BASED) {
            builder.expireAfterAccess((long)configuration.getExpireAfterAccessTime(), TimeUnit.SECONDS);
            builder.expireAfterWrite((long)configuration.getExpireAfterWriteTime(), TimeUnit.SECONDS);
        }
        if (configuration.isStatsEnabled()) {
            if (ObjectHelper.isEmpty((Object)configuration.getStatsCounter())) {
                builder.recordStats();
            } else {
                builder.recordStats(configuration::getStatsCounter);
            }
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getRemovalListener())) {
            builder.removalListener(configuration.getRemovalListener());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    CaffeineConfiguration getConfiguration() {
        return this.configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new IllegalArgumentException("The caffeine-cache component doesn't support consumer");
    }
}

