/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.processor.aggregate;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceSupport;

public class CaffeineAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private CamelContext camelContext;
    private Cache<String, DefaultExchangeHolder> cache;
    private boolean allowSerializedHeaders;
    private boolean useRecovery = true;
    private String deadLetterChannel;
    private long recoveryInterval = 5000L;
    private int maximumRedeliveries = 3;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Cache<String, DefaultExchangeHolder> getCache() {
        return this.cache;
    }

    public void setCache(Cache<String, DefaultExchangeHolder> cache) {
        this.cache = cache;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterChannel = deadLetterUri;
    }

    public String getDeadLetterUri() {
        return this.deadLetterChannel;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public String getDeadLetterChannel() {
        return this.deadLetterChannel;
    }

    public void setDeadLetterChannel(String deadLetterChannel) {
        this.deadLetterChannel = deadLetterChannel;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        this.log.trace("Adding an Exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
        DefaultExchangeHolder oldHolder = (DefaultExchangeHolder)this.cache.getIfPresent((Object)key);
        DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)true, (boolean)this.allowSerializedHeaders);
        this.cache.put((Object)key, (Object)newHolder);
        return CaffeineAggregationRepository.unmarshallExchange(camelContext, oldHolder);
    }

    public Exchange get(CamelContext camelContext, String key) {
        return CaffeineAggregationRepository.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.cache.getIfPresent((Object)key));
    }

    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        this.log.trace("Removing an exchange with ID {} for key {}", (Object)exchange.getExchangeId(), (Object)key);
        this.cache.invalidate((Object)key);
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        this.log.trace("Confirming an exchange with ID {}.", (Object)exchangeId);
        this.cache.invalidate((Object)exchangeId);
    }

    public Set<String> getKeys() {
        Set keys = this.cache.asMap().keySet();
        return Collections.unmodifiableSet(keys);
    }

    public Set<String> scan(CamelContext camelContext) {
        this.log.trace("Scanning for exchanges to recover in {} context", (Object)camelContext.getName());
        Set<String> scanned = Collections.unmodifiableSet(this.getKeys());
        this.log.trace("Found {} keys for exchanges to recover in {} context", (Object)scanned.size(), (Object)camelContext.getName());
        return scanned;
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        this.log.trace("Recovering an Exchange with ID {}.", (Object)exchangeId);
        return this.useRecovery ? CaffeineAggregationRepository.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.cache.getIfPresent((Object)exchangeId)) : null;
    }

    protected void doStart() throws Exception {
        if (this.maximumRedeliveries < 0) {
            throw new IllegalArgumentException("Maximum redelivery retries must be zero or a positive integer.");
        }
        if (this.recoveryInterval < 0L) {
            throw new IllegalArgumentException("Recovery interval must be zero or a positive integer.");
        }
        if (this.cache == null) {
            Caffeine builder = Caffeine.newBuilder();
            this.cache = builder.build();
        }
    }

    protected void doStop() throws Exception {
    }

    public static Exchange unmarshallExchange(CamelContext camelContext, DefaultExchangeHolder holder) {
        DefaultExchange exchange = null;
        if (holder != null) {
            exchange = new DefaultExchange(camelContext);
            DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
        }
        return exchange;
    }
}

