/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.annotation.BindyConverter;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.OneToMany;
import org.apache.camel.dataformat.bindy.annotation.Section;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyCsvFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BindyCsvFactory.class);
    private static final String DOUBLE_QUOTES_SYMBOL = "\"";
    boolean isOneToMany;
    private Map<Integer, DataField> dataFields = new LinkedHashMap<Integer, DataField>();
    private Map<Integer, Field> annotatedFields = new LinkedHashMap<Integer, Field>();
    private Map<String, Integer> sections = new HashMap<String, Integer>();
    private int numberOptionalFields;
    private int numberMandatoryFields;
    private int totalFields;
    private int maxpos;
    private String separator;
    private boolean skipFirstLine;
    private boolean skipField;
    private boolean generateHeaderColumnNames;
    private boolean messageOrdered;
    private String quote;
    private boolean quoting;
    private boolean autospanLine;
    private boolean allowEmptyStream;
    private boolean quotingEscaped;
    private boolean quotingOnlyWhenNeeded;
    private boolean endWithLineBreak;
    private boolean removeQuotes;

    public BindyCsvFactory(Class<?> type) throws Exception {
        super(type);
        this.initCsvModel();
    }

    public void initCsvModel() {
        this.initAnnotatedFields();
        this.initCsvRecordParameters();
    }

    @Override
    public void initAnnotatedFields() {
        this.maxpos = 0;
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class retrieved: {}", (Object)cl.getName());
            }
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                DataField dataField = field.getAnnotation(DataField.class);
                if (dataField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Position defined in the class: {}, position: {}, Field: {}", new Object[]{cl.getName(), dataField.pos(), dataField});
                    }
                    if (dataField.required()) {
                        ++this.numberMandatoryFields;
                    } else {
                        ++this.numberOptionalFields;
                    }
                    int pos = dataField.pos();
                    if (this.annotatedFields.containsKey(pos)) {
                        Field f = this.annotatedFields.get(pos);
                        LOG.warn("Potentially invalid model: existing @DataField '{}' replaced by '{}'", (Object)f.getName(), (Object)field.getName());
                    }
                    this.dataFields.put(pos, dataField);
                    this.annotatedFields.put(pos, field);
                    this.maxpos = Math.max(this.maxpos, pos);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class linked: {}, Field: {}", (Object)cl.getName(), (Object)field);
                }
                linkFields.add(field);
            }
            if (!linkFields.isEmpty()) {
                this.annotatedLinkFields.put(cl.getName(), linkFields);
            }
            this.totalFields = this.numberMandatoryFields + this.numberOptionalFields;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Number of optional fields: {}", (Object)this.numberOptionalFields);
            LOG.debug("Number of mandatory fields: {}", (Object)this.numberMandatoryFields);
            LOG.debug("Total: {}", (Object)this.totalFields);
        }
        if (this.annotatedFields.size() < this.maxpos) {
            LOG.debug("Potentially incomplete model: some csv fields may not be mapped to @DataField members");
        }
    }

    @Override
    public void bind(CamelContext camelContext, List<String> tokens, Map<String, Object> model, int line) throws Exception {
        int pos = 1;
        int counterMandatoryFields = 0;
        for (String data : tokens) {
            DataField dataField = this.dataFields.get(pos);
            if (this.isSkipField()) {
                if (this.dataFields.keySet().contains(pos)) {
                    counterMandatoryFields = this.setDataFieldValue(camelContext, model, line, pos, counterMandatoryFields, data, dataField);
                }
            } else {
                counterMandatoryFields = this.setDataFieldValue(camelContext, model, line, pos, counterMandatoryFields, data, dataField);
            }
            ++pos;
        }
        LOG.debug("Counter mandatory fields: {}", (Object)counterMandatoryFields);
        if (counterMandatoryFields < this.numberMandatoryFields) {
            throw new IllegalArgumentException("Some mandatory fields are missing, line: " + line);
        }
        if (pos < this.totalFields) {
            this.setDefaultValuesForFields(model);
        }
    }

    private int setDataFieldValue(CamelContext camelContext, Map<String, Object> model, int line, int pos, int counterMandatoryFields, String data, DataField dataField) throws Exception {
        Object value;
        ObjectHelper.notNull((Object)dataField, (String)("No position " + pos + " defined for the field: " + data + ", line: " + line));
        if (dataField.trim()) {
            data = data.trim();
        }
        if (dataField.required()) {
            ++counterMandatoryFields;
            if (data.isEmpty()) {
                throw new IllegalArgumentException("The mandatory field defined at the position " + pos + " is empty for the line: " + line);
            }
        }
        Field field = this.annotatedFields.get(pos);
        field.setAccessible(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pos: {}, Data: {}, Field type: {}", new Object[]{pos, data, field.getType()});
        }
        FormattingOptions formattingOptions = ConverterUtils.convert(dataField, field.getType(), field.getAnnotation(BindyConverter.class), this.getLocale());
        Format<?> format = this.formatFactory.getFormat(formattingOptions);
        Object modelField = model.get(field.getDeclaringClass().getName());
        if (!data.isEmpty()) {
            try {
                if (this.quoting && this.quote != null && (data.contains("\\" + this.quote) || data.contains(this.quote)) && this.quotingEscaped) {
                    value = format.parse(data.replaceAll("\\\\" + this.quote, "\\" + this.quote));
                }
                if (this.quote != null && this.quote.equals(DOUBLE_QUOTES_SYMBOL) && data.contains("\"\"") && !this.quotingEscaped) {
                    value = format.parse(data.replace("\"\"", DOUBLE_QUOTES_SYMBOL));
                }
                value = format.parse(data);
            }
            catch (FormatException ie) {
                throw new IllegalArgumentException(ie.getMessage() + ", position: " + pos + ", line: " + line, ie);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parsing error detected for field defined at the position: " + pos + ", line: " + line, e);
            }
        } else {
            value = !dataField.defaultValue().isEmpty() ? format.parse(dataField.defaultValue()) : BindyCsvFactory.getDefaultValueForPrimitive(field.getType());
        }
        if (value != null && !dataField.method().isEmpty()) {
            String methodName;
            Class clazz = dataField.method().contains(".") ? camelContext.getClassResolver().resolveMandatoryClass(dataField.method().substring(0, dataField.method().lastIndexOf(46))) : field.getType();
            Method m = ReflectionHelper.findMethod((Class)clazz, (String)(methodName = dataField.method().substring(dataField.method().lastIndexOf(46) + 1, dataField.method().length())), (Class[])new Class[]{field.getType()});
            if (m != null) {
                value = org.apache.camel.support.ObjectHelper.invokeMethod((Method)m, null, (Object[])new Object[]{value});
            } else {
                m = ReflectionHelper.findMethod((Class)clazz, (String)methodName, (Class[])new Class[0]);
                value = org.apache.camel.support.ObjectHelper.invokeMethod((Method)m, (Object)value, (Object[])new Object[0]);
            }
        }
        field.set(modelField, value);
        return counterMandatoryFields;
    }

    @Override
    public String unbind(CamelContext camelContext, Map<String, Object> model) throws Exception {
        StringBuilder buffer = new StringBuilder();
        HashMap<Integer, List<String>> results = new HashMap<Integer, List<String>>();
        ObjectHelper.notNull((Object)this.separator, (String)"The separator has not been instantiated or property not defined in the @CsvRecord annotation");
        String carriageReturn = ConverterUtils.getStringCarriageReturn(this.getCarriageReturn());
        char separator = ConverterUtils.getCharDelimiter(this.getSeparator());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Separator converted: '0x{}', from: {}", (Object)Integer.toHexString(separator), (Object)this.getSeparator());
        }
        for (Class clazz : this.models) {
            if (!model.containsKey(clazz.getName())) continue;
            Object obj = model.get(clazz.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Model object: {}, class: {}", obj, (Object)obj.getClass().getName());
            }
            if (obj == null) continue;
            this.generateCsvPositionMap(clazz, obj, results);
        }
        List<Object> l = new ArrayList();
        if (this.isOneToMany) {
            l = this.product(results);
        } else {
            TreeMap<Integer, List<String>> sortValues = new TreeMap<Integer, List<String>>(results);
            ArrayList<String> temp = new ArrayList<String>();
            for (Map.Entry<Integer, List<String>> entry : sortValues.entrySet()) {
                List<String> val = entry.getValue();
                String value = val.get(0);
                if (value != null) {
                    temp.add(value);
                    continue;
                }
                temp.add("");
            }
            l.add(temp);
        }
        Iterator<Object> it = l.iterator();
        while (it.hasNext()) {
            List tokens = (List)it.next();
            Iterator itx = tokens.iterator();
            while (itx.hasNext()) {
                String res = (String)itx.next();
                if (res != null) {
                    boolean needsQuotes;
                    boolean bl = needsQuotes = this.quoting && this.quote != null && (!this.quotingOnlyWhenNeeded || res.contains(carriageReturn) || res.indexOf(separator) != -1 || res.contains(this.quote));
                    if (needsQuotes) {
                        buffer.append(this.quote);
                        if (this.quotingEscaped && (res.contains("\\" + this.quote) || res.contains(this.quote))) {
                            buffer.append(res.replaceAll("\\" + this.quote, "\\\\" + this.quote));
                        } else if (!this.quotingEscaped && this.quote.equals(DOUBLE_QUOTES_SYMBOL) && res.contains(this.quote)) {
                            buffer.append(res.replace(DOUBLE_QUOTES_SYMBOL, "\"\""));
                        } else {
                            buffer.append(res);
                        }
                        buffer.append(this.quote);
                    } else {
                        buffer.append(res);
                    }
                }
                if (!itx.hasNext()) continue;
                buffer.append(separator);
            }
            if (!it.hasNext()) continue;
            buffer.append(ConverterUtils.getStringCarriageReturn(this.getCarriageReturn()));
        }
        return buffer.toString();
    }

    private List<List<String>> product(Map<Integer, List<String>> values) {
        int idxSize;
        TreeMap<Integer, List<String>> sortValues = new TreeMap<Integer, List<String>>(values);
        ArrayList<List<String>> product = new ArrayList<List<String>>();
        int idx = 0;
        do {
            idxSize = 0;
            ArrayList<String> v = new ArrayList<String>();
            for (int ii = 1; ii <= sortValues.lastKey(); ++ii) {
                List<String> l = values.get(ii);
                if (l == null) {
                    v.add("");
                    ++idxSize;
                    continue;
                }
                if (l.size() >= idx + 1) {
                    v.add(l.get(idx));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Value: {}, pos: {}, at: {}", new Object[]{l.get(idx), ii, idx});
                    continue;
                }
                v.add(l.get(0));
                ++idxSize;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Value: {}, pos: {}, at index: {}", new Object[]{l.get(0), ii, 0});
            }
            if (idxSize != sortValues.lastKey()) {
                product.add(v);
            }
            ++idx;
        } while (idxSize != sortValues.lastKey());
        return product;
    }

    private void generateCsvPositionMap(Class<?> clazz, Object obj, Map<Integer, List<String>> results) throws Exception {
        String result = "";
        for (Field field : clazz.getDeclaredFields()) {
            OneToMany oneToMany;
            List<Object> list;
            field.setAccessible(true);
            DataField datafield = field.getAnnotation(DataField.class);
            if (datafield != null) {
                Integer key;
                if (obj != null) {
                    FormattingOptions formattingOptions = ConverterUtils.convert(datafield, field.getType(), field.getAnnotation(BindyConverter.class), this.getLocale());
                    Format<?> format = this.formatFactory.getFormat(formattingOptions);
                    Object value = field.get(obj);
                    if (ObjectHelper.isNotEmpty((String)datafield.defaultValue()) && ObjectHelper.isEmpty((Object)value)) {
                        value = datafield.defaultValue();
                    }
                    result = this.formatString(format, value);
                    if (datafield.trim()) {
                        result = result.trim();
                    }
                    if (datafield.clip() && result.length() > datafield.length()) {
                        result = result.substring(0, datafield.length());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Value to be formatted: {}, position: {}, and its formatted value: {}", new Object[]{value, datafield.pos(), result});
                    }
                } else {
                    result = "";
                }
                if (this.isMessageOrdered() && obj != null) {
                    Integer key1 = this.sections.get(obj.getClass().getName());
                    Integer key2 = datafield.position();
                    Integer n = BindyCsvFactory.generateKey(key1, key2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Key generated: {}, for section: {}", (Object)String.valueOf(n), (Object)key1);
                    }
                    key = n;
                } else {
                    key = datafield.pos();
                }
                if (!results.containsKey(key)) {
                    list = new LinkedList<String>();
                    list.add(result);
                    results.put(key, list);
                } else {
                    list = results.get(key);
                    list.add(result);
                }
            }
            if ((oneToMany = field.getAnnotation(OneToMany.class)) == null) continue;
            this.isOneToMany = true;
            list = (LinkedList<String>)field.get(obj);
            if (list != null) {
                for (Object e : list) {
                    this.generateCsvPositionMap(e.getClass(), e, results);
                }
                continue;
            }
            this.generateCsvPositionMap(field.getClass(), null, results);
        }
    }

    public String generateHeader() {
        TreeMap<Integer, DataField> dataFieldsSorted = new TreeMap<Integer, DataField>(this.dataFields);
        Iterator it = dataFieldsSorted.keySet().iterator();
        StringBuilder builderHeader = new StringBuilder();
        while (it.hasNext()) {
            DataField dataField = (DataField)dataFieldsSorted.get(it.next());
            Field field = this.annotatedFields.get(dataField.pos());
            field.setAccessible(true);
            String res = !dataField.columnName().isEmpty() ? dataField.columnName() : field.getName();
            if (this.quoting && this.quote != null) {
                builderHeader.append(this.quote);
            }
            if (this.quoting && this.quote != null && (res.contains("\\" + this.quote) || res.contains(this.quote)) && this.quotingEscaped) {
                builderHeader.append(res.replaceAll("\\" + this.quote, "\\\\" + this.quote));
            } else {
                builderHeader.append(res);
            }
            if (this.quoting && this.quote != null) {
                builderHeader.append(this.quote);
            }
            if (!it.hasNext()) continue;
            builderHeader.append(ConverterUtils.getCharDelimiter(this.separator));
        }
        return builderHeader.toString();
    }

    private void initCsvRecordParameters() {
        if (this.separator == null) {
            for (Class cl : this.models) {
                CsvRecord record = cl.getAnnotation(CsvRecord.class);
                Section section = cl.getAnnotation(Section.class);
                if (record != null) {
                    LOG.debug("Csv record: {}", (Object)record);
                    this.skipFirstLine = record.skipFirstLine();
                    LOG.debug("Skip First Line parameter of the CSV: {}", (Object)this.skipFirstLine);
                    this.skipField = record.skipField();
                    LOG.debug("Skip Field parameter of the CSV: {}", (Object)this.skipField);
                    this.generateHeaderColumnNames = record.generateHeaderColumns();
                    LOG.debug("Generate header column names parameter of the CSV: {}", (Object)this.generateHeaderColumnNames);
                    ObjectHelper.notNull((Object)record.separator(), (String)"No separator has been defined in the @Record annotation");
                    this.separator = record.separator();
                    LOG.debug("Separator defined for the CSV: {}", (Object)this.separator);
                    this.crlf = record.crlf();
                    LOG.debug("Carriage return defined for the CSV: {}", (Object)this.crlf);
                    this.messageOrdered = record.isOrdered();
                    LOG.debug("Must CSV record be ordered: {}", (Object)this.messageOrdered);
                    if (ObjectHelper.isNotEmpty((String)record.quote())) {
                        this.quote = record.quote();
                        LOG.debug("Quoting columns with: {}", (Object)this.quote);
                    }
                    this.quoting = record.quoting();
                    LOG.debug("CSV will be quoted: {}", (Object)this.quoting);
                    this.autospanLine = record.autospanLine();
                    LOG.debug("Autospan line in last record: {}", (Object)this.autospanLine);
                    this.allowEmptyStream = record.allowEmptyStream();
                    LOG.debug("Allow empty stream parameter of the CSV: {}", (Object)this.allowEmptyStream);
                    this.quotingEscaped = record.quotingEscaped();
                    LOG.debug("Escape quote character flag of the CSV: {}", (Object)this.quotingEscaped);
                    this.quotingOnlyWhenNeeded = record.quotingOnlyWhenNeeded();
                    LOG.debug("Quoting only when needed: {}", (Object)this.quotingOnlyWhenNeeded);
                    this.endWithLineBreak = record.endWithLineBreak();
                    LOG.debug("End with line break: {}", (Object)this.endWithLineBreak);
                    this.removeQuotes = record.removeQuotes();
                    LOG.debug("Remove quotes: {}", (Object)this.removeQuotes);
                }
                if (section == null) continue;
                ObjectHelper.notNull((Object)section.number(), (String)"No number has been defined for the section");
                this.sections.put(cl.getName(), section.number());
            }
        }
    }

    private void setDefaultValuesForFields(Map<String, Object> model) throws Exception {
        for (int i = 1; i <= this.dataFields.size(); ++i) {
            Field field = this.annotatedFields.get(i);
            field.setAccessible(true);
            DataField dataField = this.dataFields.get(i);
            Object modelField = model.get(field.getDeclaringClass().getName());
            if (field.get(modelField) != null || dataField.defaultValue().isEmpty()) continue;
            FormattingOptions formattingOptions = ConverterUtils.convert(dataField, field.getType(), field.getAnnotation(BindyConverter.class), this.getLocale());
            Format<?> format = this.formatFactory.getFormat(formattingOptions);
            Object value = format.parse(dataField.defaultValue());
            field.set(modelField, value);
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean getGenerateHeaderColumnNames() {
        return this.generateHeaderColumnNames;
    }

    public boolean getSkipFirstLine() {
        return this.skipFirstLine;
    }

    public boolean isSkipField() {
        return this.skipField;
    }

    public boolean getAutospanLine() {
        return this.autospanLine;
    }

    public boolean isMessageOrdered() {
        return this.messageOrdered;
    }

    public String getQuote() {
        return this.quote;
    }

    public Boolean getRemoveQuotes() {
        return this.removeQuotes;
    }

    public int getMaxpos() {
        return this.maxpos;
    }

    public boolean isAllowEmptyStream() {
        return this.allowEmptyStream;
    }

    public boolean isEndWithLineBreak() {
        return this.endWithLineBreak;
    }
}

