/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;

public class BooleanFormatFactory
extends AbstractFormatFactory {
    private final BooleanFormat booleanFormat = new BooleanFormat();

    public BooleanFormatFactory() {
        this.supportedClasses.add(Boolean.TYPE);
        this.supportedClasses.add(Boolean.class);
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return this.booleanFormat;
    }

    private static class BooleanFormat
    implements Format<Boolean> {
        private BooleanFormat() {
        }

        @Override
        public String format(Boolean object) throws Exception {
            return object.toString();
        }

        @Override
        public Boolean parse(String string) throws Exception {
            return Boolean.valueOf(string);
        }
    }
}

