/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.util.Locale;
import org.apache.camel.dataformat.bindy.annotation.BindyConverter;
import org.apache.camel.util.ObjectHelper;

public class FormattingOptions {
    private String pattern;
    private Locale locale;
    private String timezone;
    private int precision;
    private String rounding;
    private boolean impliedDecimalSeparator;
    private String decimalSeparator;
    private String groupingSeparator;
    private Class<?> clazz;
    private BindyConverter bindyConverter;

    public String getPattern() {
        return this.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getRounding() {
        return this.rounding;
    }

    public boolean isImpliedDecimalSeparator() {
        return this.impliedDecimalSeparator;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public String getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public FormattingOptions withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public FormattingOptions withLocale(String locale) {
        this.locale = this.getLocale(locale);
        return this;
    }

    public FormattingOptions withTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public FormattingOptions withPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public FormattingOptions withRounding(String rounding) {
        this.rounding = rounding;
        return this;
    }

    public FormattingOptions withImpliedDecimalSeparator(boolean impliedDecimalSeparator) {
        this.impliedDecimalSeparator = impliedDecimalSeparator;
        return this;
    }

    public FormattingOptions withDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        return this;
    }

    public FormattingOptions withGroupingSeparator(String groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
        return this;
    }

    public FormattingOptions forClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private Locale getLocale(String locale) {
        String[] result;
        if ("default".equals(locale)) {
            return Locale.getDefault();
        }
        Locale answer = null;
        if (ObjectHelper.isNotEmpty((Object)locale) && (result = locale.split("-")).length <= 2) {
            answer = result.length == 1 ? new Locale(result[0]) : new Locale(result[0], result[1]);
        }
        return answer;
    }

    public FormattingOptions withBindyConverter(BindyConverter bindyConverter) {
        this.bindyConverter = bindyConverter;
        return this;
    }

    public BindyConverter getBindyConverter() {
        return this.bindyConverter;
    }
}

