/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;

public abstract class BindyAbstractDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private String locale;
    private BindyAbstractFactory modelFactory;
    private Class<?> classType;

    public BindyAbstractDataFormat() {
    }

    protected BindyAbstractDataFormat(Class<?> classType) {
        this.classType = classType;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public void setClassType(Class<?> classType) {
        this.classType = classType;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public BindyAbstractFactory getFactory() throws Exception {
        if (this.modelFactory == null) {
            this.modelFactory = this.createModelFactory();
            this.modelFactory.setLocale(this.locale);
        }
        return this.modelFactory;
    }

    public void setModelFactory(BindyAbstractFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    protected abstract BindyAbstractFactory createModelFactory() throws Exception;

    protected Object extractUnmarshalResult(List<Map<String, Object>> models) {
        if (this.getClassType() != null) {
            ArrayList<Object> answer = new ArrayList<Object>();
            for (Map<String, Object> entry : models) {
                Object data = entry.get(this.getClassType().getName());
                if (data == null) continue;
                answer.add(data);
            }
            if (answer.size() == 1) {
                return answer.get(0);
            }
            return answer;
        }
        return models;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

