/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.CsvRecord;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindyCsvFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Log LOG = LogFactory.getLog(BindyCsvFactory.class);
    private Map<Integer, DataField> mapDataField = new LinkedHashMap<Integer, DataField>();
    private Map<Integer, Field> mapAnnotedField = new LinkedHashMap<Integer, Field>();
    private String separator;
    private boolean skipFirstLine;

    public BindyCsvFactory(PackageScanClassResolver resolver, String packageName) throws Exception {
        super(resolver, packageName);
        this.initCsvModel();
    }

    public void initCsvModel() throws Exception {
        this.initAnnotedFields();
        this.initCsvRecordParameters();
    }

    @Override
    public void initAnnotedFields() {
        for (Class cl : this.models) {
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                DataField dataField = field.getAnnotation(DataField.class);
                if (dataField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Position defined in the class : " + cl.getName() + ", position : " + dataField.pos() + ", Field : " + dataField.toString()));
                    }
                    this.mapDataField.put(dataField.pos(), dataField);
                    this.mapAnnotedField.put(dataField.pos(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Class linked  : " + cl.getName() + ", Field" + field.toString()));
                }
                this.mapAnnotedLinkField.put(cl.getName(), field);
            }
        }
    }

    @Override
    public void bind(List<String> data, Map<String, Object> model) throws Exception {
        for (int pos = 0; pos < data.size(); ++pos) {
            if (data.get(pos).equals("")) continue;
            DataField dataField = this.mapDataField.get(pos);
            ObjectHelper.notNull((Object)dataField, (String)("No position defined for the field positoned : " + pos));
            Field field = this.mapAnnotedField.get(pos);
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pos : " + pos + ", Data : " + data.get(pos) + ", Field type : " + field.getType()));
            }
            String pattern = dataField.pattern();
            Format<?> format = FormatFactory.getFormat(field.getType(), pattern, dataField.precision());
            field.set(model.get(field.getDeclaringClass().getName()), format.parse(data.get(pos)));
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder builder = new StringBuilder();
        TreeMap<Integer, DataField> dataFields = new TreeMap<Integer, DataField>(this.mapDataField);
        Iterator it = dataFields.keySet().iterator();
        ObjectHelper.notNull((Object)this.separator, (String)"The separator has not been instantiated or property not defined in the @CsvRecord annotation");
        while (it.hasNext()) {
            DataField dataField = this.mapDataField.get(it.next());
            Field field = this.mapAnnotedField.get(dataField.pos());
            field.setAccessible(true);
            Format<?> format = FormatFactory.getFormat(field.getType(), dataField.pattern(), dataField.precision());
            Object obj = model.get(field.getDeclaringClass().getName());
            builder.append(format.format(field.get(obj)));
            if (!it.hasNext()) continue;
            builder.append(this.getSeparator());
        }
        return builder.toString();
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean getSkipFirstLine() {
        return this.skipFirstLine;
    }

    private void initCsvRecordParameters() {
        if (this.separator == null) {
            for (Class cl : this.models) {
                CsvRecord record = cl.getAnnotation(CsvRecord.class);
                if (record == null) continue;
                this.skipFirstLine = record.skipFirstLine();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skip First Line parameter of the CSV : " + this.skipFirstLine));
                }
                ObjectHelper.notNull((Object)record.separator(), (String)"No separator has been defined in the @Record annotation !");
                this.separator = record.separator();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Separator defined for the CSV : " + this.separator));
                }
                this.crlf = record.crlf();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Carriage return defined for the CSV : " + this.crlf));
            }
        }
    }
}

