/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.beanio;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.beanio.BeanIOConfiguration;
import org.apache.camel.dataformat.beanio.BeanIOHeader;
import org.apache.camel.dataformat.beanio.BeanIOHelper;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;
import org.beanio.BeanWriter;
import org.beanio.StreamFactory;

public class BeanIODataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private transient CamelContext camelContext;
    private transient StreamFactory factory;
    private BeanIOConfiguration configuration = new BeanIOConfiguration();

    public BeanIODataFormat() {
    }

    public BeanIODataFormat(String mapping, String streamName) {
        this.setMapping(mapping);
        this.setStreamName(streamName);
    }

    public String getDataFormatName() {
        return "beanio";
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.getStreamName(), (String)"Stream name not configured.");
        if (this.factory == null) {
            this.factory = StreamFactory.newInstance();
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getMapping());
            try {
                if (this.getProperties() != null) {
                    this.factory.load(is, this.getProperties());
                } else {
                    this.factory.load(is);
                }
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
    }

    protected void doStop() throws Exception {
        this.factory = null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    StreamFactory getFactory() {
        return this.factory;
    }

    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        List<Object> models = this.getModels(exchange, body);
        this.writeModels(stream, models);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.readModels(exchange, stream);
    }

    private List<Object> getModels(Exchange exchange, Object body) {
        ArrayList models = (ArrayList)exchange.getContext().getTypeConverter().convertTo(List.class, body);
        if (models == null) {
            models = new ArrayList();
            Iterator it = ObjectHelper.createIterator((Object)body);
            while (it.hasNext()) {
                models.add(it.next());
            }
        }
        return models;
    }

    private void writeModels(OutputStream stream, List<Object> models) {
        BufferedWriter streamWriter = IOHelper.buffered((Writer)new OutputStreamWriter(stream, this.getEncoding()));
        BeanWriter out = this.factory.createWriter(this.getStreamName(), (Writer)streamWriter);
        for (Object obj : models) {
            out.write(obj);
        }
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readModels(Exchange exchange, InputStream stream) throws Exception {
        ArrayList<Object> results = new ArrayList<Object>();
        BufferedReader streamReader = IOHelper.buffered((Reader)new InputStreamReader(stream, this.getEncoding()));
        BeanReader in = this.factory.createReader(this.getStreamName(), (Reader)streamReader);
        BeanReaderErrorHandler errorHandler = BeanIOHelper.getOrCreateBeanReaderErrorHandler(this.configuration, exchange, results, null);
        in.setErrorHandler(errorHandler);
        try {
            Object readObject;
            while ((readObject = in.read()) != null) {
                if (readObject instanceof BeanIOHeader) {
                    exchange.getOut().getHeaders().putAll(((BeanIOHeader)readObject).getHeaders());
                }
                results.add(readObject);
            }
        }
        finally {
            in.close();
        }
        return results;
    }

    public String getMapping() {
        return this.configuration.getMapping();
    }

    public void setIgnoreUnexpectedRecords(boolean ignoreUnexpectedRecords) {
        this.configuration.setIgnoreUnexpectedRecords(ignoreUnexpectedRecords);
    }

    public void setProperties(Properties properties) {
        this.configuration.setProperties(properties);
    }

    public void setStreamName(String streamName) {
        this.configuration.setStreamName(streamName);
    }

    public boolean isIgnoreUnidentifiedRecords() {
        return this.configuration.isIgnoreUnidentifiedRecords();
    }

    public boolean isIgnoreInvalidRecords() {
        return this.configuration.isIgnoreInvalidRecords();
    }

    public void setIgnoreInvalidRecords(boolean ignoreInvalidRecords) {
        this.configuration.setIgnoreInvalidRecords(ignoreInvalidRecords);
    }

    public void setEncoding(String encoding) {
        this.setEncoding(Charset.forName(encoding));
    }

    public void setEncoding(Charset encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("Charset encoding is null");
        }
        this.configuration.setEncoding(encoding);
    }

    public boolean isIgnoreUnexpectedRecords() {
        return this.configuration.isIgnoreUnexpectedRecords();
    }

    public Properties getProperties() {
        return this.configuration.getProperties();
    }

    public String getStreamName() {
        return this.configuration.getStreamName();
    }

    public void setMapping(String mapping) {
        this.configuration.setMapping(mapping);
    }

    public void setIgnoreUnidentifiedRecords(boolean ignoreUnidentifiedRecords) {
        this.configuration.setIgnoreUnidentifiedRecords(ignoreUnidentifiedRecords);
    }

    public Charset getEncoding() {
        return this.configuration.getEncoding();
    }

    public BeanReaderErrorHandler getBeanReaderErrorHandler() {
        return this.configuration.getBeanReaderErrorHandler();
    }

    public void setBeanReaderErrorHandler(BeanReaderErrorHandler beanReaderErrorHandler) {
        this.configuration.setBeanReaderErrorHandler(beanReaderErrorHandler);
    }

    public String getBeanReaderErrorHandlerType() {
        return this.configuration.getBeanReaderErrorHandlerType();
    }

    public void setBeanReaderErrorHandlerType(String beanReaderErrorHandlerType) {
        this.configuration.setBeanReaderErrorHandlerType(beanReaderErrorHandlerType);
    }

    public void setBeanReaderErrorHandlerType(Class<?> beanReaderErrorHandlerType) {
        this.configuration.setBeanReaderErrorHandlerType(beanReaderErrorHandlerType);
    }
}

