/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.ParameterMappingStrategyHelper;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@Language(value="bean")
public class BeanLanguage
extends LanguageSupport
implements PropertyConfigurer,
StaticService {
    private volatile BeanComponent beanComponent;
    private volatile ParameterMappingStrategy parameterMappingStrategy;
    private volatile org.apache.camel.spi.Language simple;
    private Object bean;
    private Class<?> beanType;
    private String ref;
    private String method;
    private BeanScope scope = BeanScope.Singleton;

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public BeanScope getScope() {
        return this.scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope;
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bean": {
                this.setBean(PropertyConfigurerSupport.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "beantype": 
            case "beanType": {
                this.setBeanType((Class)PropertyConfigurerSupport.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "ref": {
                this.setRef((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "method": {
                this.setMethod((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "scope": {
                this.setScope((BeanScope)PropertyConfigurerSupport.property((CamelContext)camelContext, BeanScope.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression, properties));
    }

    public Expression createExpression(String expression, Object[] properties) {
        String ref;
        Class beanType;
        BeanExpression answer = null;
        String method = (String)properties[1];
        Object bean = properties[0];
        if (bean != null) {
            answer = new BeanExpression(bean, method);
        }
        if (answer == null && (beanType = (Class)properties[2]) != null) {
            answer = new BeanExpression(beanType, method);
        }
        if (answer == null && (ref = (String)properties[3]) != null) {
            answer = new BeanExpression(ref, method);
        }
        if (answer == null) {
            throw new IllegalArgumentException("Bean language requires bean, beanType, or ref argument");
        }
        if (properties.length == 5) {
            Object scope = properties[4];
            if (scope instanceof BeanScope) {
                answer.setScope((BeanScope)scope);
            } else if (scope != null) {
                answer.setScope(BeanScope.valueOf((String)scope.toString()));
            }
        }
        answer.setBeanComponent(this.beanComponent);
        answer.setParameterMappingStrategy(this.parameterMappingStrategy);
        answer.setSimple(this.simple);
        answer.init(this.getCamelContext());
        return answer;
    }

    public Expression createExpression(String expression) {
        BeanExpression answer;
        String beanScope = null;
        if (this.bean != null) {
            answer = new BeanExpression(this.bean, this.method);
        } else if (this.beanType != null) {
            answer = new BeanExpression(this.beanType, this.method);
        } else if (this.ref != null) {
            answer = new BeanExpression(this.ref, this.method);
        } else {
            String beanName = expression;
            String method = null;
            if (expression.contains("?method=") || expression.contains("?scope=")) {
                beanName = StringHelper.before((String)expression, (String)"?");
                String query = StringHelper.after((String)expression, (String)"?");
                try {
                    Map map = URISupport.parseQuery((String)query);
                    method = (String)map.get("method");
                    beanScope = (String)map.get("scope");
                }
                catch (URISyntaxException e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            } else {
                int doubleColonIndex = expression.indexOf("::");
                int beginOfParameterDeclaration = expression.indexOf(40);
                if (!(doubleColonIndex <= 0 || expression.contains("(") && doubleColonIndex >= beginOfParameterDeclaration)) {
                    beanName = expression.substring(0, doubleColonIndex);
                    method = expression.substring(doubleColonIndex + 2);
                } else {
                    int idx = expression.indexOf(46);
                    if (idx > 0) {
                        beanName = expression.substring(0, idx);
                        method = expression.substring(idx + 1);
                    }
                }
            }
            if (beanName.startsWith("type:")) {
                try {
                    Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(beanName.substring(5));
                    answer = new BeanExpression(clazz, method);
                }
                catch (ClassNotFoundException e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            } else {
                answer = new BeanExpression(beanName, method);
            }
        }
        if (beanScope != null) {
            answer.setScope((BeanScope)this.getCamelContext().getTypeConverter().tryConvertTo(BeanScope.class, beanScope));
        } else {
            answer.setScope(this.scope);
        }
        answer.setBeanComponent(this.beanComponent);
        answer.setParameterMappingStrategy(this.parameterMappingStrategy);
        answer.setSimple(this.simple);
        answer.init(this.getCamelContext());
        return answer;
    }

    public void start() {
        this.beanComponent = (BeanComponent)this.getCamelContext().getComponent("bean", BeanComponent.class);
        this.parameterMappingStrategy = ParameterMappingStrategyHelper.createParameterMappingStrategy(this.getCamelContext());
        this.simple = this.getCamelContext().resolveLanguage("simple");
    }

    public void stop() {
    }
}

